/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging.formatting;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class ChrisNormalLogFormatter
extends Formatter {
    private final Date date = new Date();
    private final Object[] args = new Object[1];
    private static final MessageFormat FORMATTER = new MessageFormat("{0,date} {0,time}");
    private static final String LINE_SEP = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(256);
        this.date.setTime(record.getMillis());
        this.args[0] = this.date;
        StringBuffer text = new StringBuffer();
        FORMATTER.format(this.args, text, (FieldPosition)null);
        sb.append(text);
        sb.append(' ');
        sb.append(record.getLevel().getLocalizedName());
        sb.append(' ');
        sb.append(record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(46) + 1));
        sb.append('.');
        sb.append(record.getSourceMethodName());
        sb.append("() ");
        String message = this.formatMessage(record);
        sb.append(message);
        sb.append(LINE_SEP);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                sb.append("*** Problem formatting exception ***");
            }
        }
        return sb.toString();
    }
}

