/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging.formatting;

import ir.middleware.ExceptionManager.ExceptionManager;
import ir.middleware.ExceptionManager.IRException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class MiddlewareIncidentHandler
extends Handler {
    private static final int MSG_SET = 61;
    private static final int MSG_NUM_EXCEPTION = 1;
    private static final int MSG_NUM_WARNING = 1001;

    public MiddlewareIncidentHandler() {
        this.setLevel(Level.WARNING);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            String clazz = "unknown";
            if (record.getSourceClassName() != null) {
                clazz = record.getSourceClassName();
            }
            String method = "unknown";
            if (record.getSourceMethodName() != null) {
                method = record.getSourceMethodName();
            }
            Throwable exception = record.getThrown();
            if (record.getLevel() == Level.WARNING) {
                ExceptionManager.reportWarning((int)61, (int)1001, (String[])new String[]{record.getMessage()}, (String)clazz, (String)method, (Throwable)exception, IRException.class);
            } else if (record.getLevel() == Level.SEVERE) {
                ExceptionManager.reportException((int)61, (int)1, (String[])new String[]{record.getMessage()}, (String)clazz, (String)method, (Throwable)exception, IRException.class);
            }
        }
        catch (Exception e) {
            System.err.println("Coudln't create incident for " + record + ".  Nested ex. is:");
            e.printStackTrace(System.err);
        }
    }
}

