/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.map;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.XMLHandler;
import uk.gov.hmrc.chris.spox.utils.SPOXUtils;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class MapUtils {
    public static InputStream mapToXML(Map<String, String> dataSet) throws XMLBuilder.XMLBuilderException {
        XMLBuilder xmlBuilder = new XMLBuilder();
        xmlBuilder.writeStartElement("Map");
        for (String key : dataSet.keySet()) {
            xmlBuilder.writeStartElement("Item");
            xmlBuilder.writeSimpleElement("Key", key);
            xmlBuilder.writeSimpleElement("Value", dataSet.get(key));
            xmlBuilder.writeEndElement();
        }
        xmlBuilder.writeEndElement();
        xmlBuilder.endDocument();
        return xmlBuilder.toInputSTream();
    }

    public static void xMLtoMap(Map<String, String> toMap, InputStream xml) throws XMLBuilder.XMLBuilderException {
        DataListener listener = new DataListener(toMap);
        XMLHandler handler = new XMLHandler(listener);
        handler.readXML(xml);
    }

    public static Map<String, String> xMLtoMap(InputStream xml) throws XMLBuilder.XMLBuilderException {
        HashMap<String, String> toMap = new HashMap<String, String>();
        MapUtils.xMLtoMap(toMap, xml);
        return toMap;
    }

    private static class DataListener
    implements Listener {
        private static final String KEY = "Key";
        private static final String VALUE = "Value";
        private boolean inxPath = false;
        private StringBuffer key = new StringBuffer();
        private StringBuffer value = new StringBuffer();
        private String currentElement;
        private Map<String, String> dataSet;

        public DataListener(Map<String, String> toMap) {
            this.dataSet = toMap;
        }

        @Override
        public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
            if (this.inxPath) {
                this.currentElement = SPOXUtils.stripNameSpaceFromNode(name);
            }
        }

        @Override
        public void endElementFound(String name) throws SPOXException {
            this.currentElement = null;
        }

        @Override
        public void xpathFinished() throws SPOXException {
            this.inxPath = false;
            String keyElement = this.key.length() == 0 ? null : this.key.toString();
            String valueElement = this.value.length() == 0 ? null : this.value.toString();
            this.dataSet.put(keyElement, valueElement);
            this.key.delete(0, this.key.length());
            this.value.delete(0, this.value.length());
        }

        @Override
        public void xpathFound(String xpath) throws SPOXException {
            this.inxPath = true;
        }

        @Override
        public void characterDataFound(char[] data, int Size) throws SPOXException {
            if (this.currentElement.equals(KEY)) {
                this.key.append(data);
            }
            if (this.currentElement.equals(VALUE)) {
                this.value.append(data);
            }
        }

        @Override
        public void commentFound(char[] arg0, int start, int length) {
        }

        @Override
        public String[] getXPaths() throws SPOXException {
            return new String[]{"/Map/Item"};
        }

        @Override
        public void documentFinished() throws SPOXException {
        }

        @Override
        public void documentStarted() throws SPOXException {
        }

        @Override
        public String getNameSpace() throws SPOXException {
            return null;
        }

        @Override
        public void nameSpaceFinished() throws SPOXException {
        }

        @Override
        public void nameSpaceFound() throws SPOXException {
        }

        @Override
        public void reset() throws SPOXException {
        }
    }
}

