/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.posties;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import uk.gov.hmrc.chRIS.service.control.ControlDocumentDocument1;
import uk.gov.hmrc.chRIS.service.control.header.HeaderDocument;
import uk.gov.hmrc.chRIS.service.control.metaData.MetaDataDocument;
import uk.gov.hmrc.chRIS.service.request.responseRoute.ResponseRouteDocument;
import uk.gov.hmrc.chris.utils.controldocument.Processor;
import uk.gov.hmrc.chris.utils.posties.PostieException;
import uk.gov.hmrc.chris.utils.posties.http.HTTPPostie;
import uk.gov.hmrc.chris.utils.posties.jdbc.JDBCPostie;
import uk.gov.hmrc.chris.utils.posties.jms.JMSPostie;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandler;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandlerException;
import uk.gov.hmrc.chris.utils.streaming.StringUtils;

public class Responder
implements ResourceHandler {
    private ResponseRouteDocument.ResponseRoute config;
    private OutputStream respStream = null;
    private ArrayList<HTTPPostie> httpPosties = new ArrayList();

    public Responder(ResponseRouteDocument.ResponseRoute config) {
        this.config = config;
    }

    public Responder(ResponseRouteDocument.ResponseRoute config, OutputStream respOutputStream) {
        this.config = config;
        this.respStream = respOutputStream;
    }

    public void acceptResponse(ControlDocumentDocument1.ControlDocument controlDocument, String key) {
        Processor processor = null;
        HeaderDocument.Header header = null;
        MetaDataDocument.MetaData metaData = null;
        try {
            ResponseRouteDocument.ResponseRoute.Channel channel = this.config.getChannel();
            if (channel.isSetJMS()) {
                ResponseRouteDocument.ResponseRoute.Channel.JMS jms = channel.getJMS();
                ResponseRouteDocument.ResponseRoute.Channel.JMS.Accept acceptJMS = jms.getAccept();
                ControlDocumentDocument1.ControlDocument.BreadCrumbTrail breadCrumbTrail = controlDocument.getBreadCrumbTrail();
                ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue[] queueArray = breadCrumbTrail.getQueueArray();
                List<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue> queueList = queueArray != null ? Arrays.asList(queueArray) : new ArrayList<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue>();
                ArrayList<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue> queueArrayList = new ArrayList<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue>(queueList);
                ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue queue = breadCrumbTrail.addNewQueue();
                queue.setName(acceptJMS.getQueueName());
                queue.setTimestamp(this.getCurrentTimestampAsCalender());
                queueArrayList.add(queue);
                breadCrumbTrail.setQueueArray(queueArrayList.toArray(new ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue[queueArrayList.size()]));
                controlDocument.setBreadCrumbTrail(breadCrumbTrail);
                JMSPostie jmsPostie = new JMSPostie(acceptJMS.getQueueName(), acceptJMS.getConnectionFactory(), acceptJMS.getServersList());
                processor = new Processor();
                header = processor.getHeader((XmlObject)controlDocument);
                metaData = processor.getMetaData((XmlObject)controlDocument);
                jmsPostie.setConversationId(header.getConversationID());
                jmsPostie.setCorrelationId(metaData.getCapture().getID());
                jmsPostie.setLob(header.getLOB().toString());
                jmsPostie.setMessageClass(metaData.getMessageClass());
                jmsPostie.send(controlDocument.newCursor().xmlText());
            } else if (channel.isSetHTTP()) {
                ResponseRouteDocument.ResponseRoute.Channel.HTTP http = channel.getHTTP();
                ResponseRouteDocument.ResponseRoute.Channel.HTTP.Accept acceptHttp = http.getAccept();
                HTTPPostie httpPostie = new HTTPPostie(acceptHttp.getURI(), acceptHttp.getPort(), acceptHttp.getMachine());
                httpPostie.send(StringUtils.convertStringToInputStream(controlDocument.xmlText()));
            } else if (channel.isSetJDBC()) {
                ResponseRouteDocument.ResponseRoute.Channel.JDBC jdbc = channel.getJDBC();
                ResponseRouteDocument.ResponseRoute.Channel.JDBC.Accept acceptJDBC = jdbc.getAccept();
                JDBCPostie jdbcPostie = new JDBCPostie(acceptJDBC.getTable().getName(), acceptJDBC.getTable().getKeyColumn(), acceptJDBC.getTable().getDataColumn(), acceptJDBC.getDatasource());
                jdbcPostie.send(StringUtils.convertStringToInputStream(controlDocument.xmlText()), key);
            } else if (this.respStream != null) {
                String response = controlDocument.newCursor().xmlText();
                this.respStream.write(response.getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            throw new PostieException(e.getMessage(), e);
        }
    }

    public void rejectResponse(ControlDocumentDocument1.ControlDocument controlDocument, String key) {
        Processor processor = null;
        HeaderDocument.Header header = null;
        MetaDataDocument.MetaData metaData = null;
        try {
            ResponseRouteDocument.ResponseRoute.Channel channel = this.config.getChannel();
            if (channel.isSetJMS()) {
                ResponseRouteDocument.ResponseRoute.Channel.JMS jms = channel.getJMS();
                ResponseRouteDocument.ResponseRoute.Channel.JMS.Reject rejectJMS = jms.getReject();
                ControlDocumentDocument1.ControlDocument.BreadCrumbTrail breadCrumbTrail = controlDocument.getBreadCrumbTrail();
                ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue[] queueArray = breadCrumbTrail.getQueueArray();
                List<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue> queueList = Arrays.asList(queueArray);
                ArrayList<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue> queueArrayList = new ArrayList<ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue>(queueList);
                ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue queue = breadCrumbTrail.addNewQueue();
                queue.setName(rejectJMS.getQueueName());
                queue.setTimestamp(this.getCurrentTimestampAsCalender());
                queueArrayList.add(queue);
                breadCrumbTrail.setQueueArray(queueArrayList.toArray(new ControlDocumentDocument1.ControlDocument.BreadCrumbTrail.Queue[queueArrayList.size()]));
                controlDocument.setBreadCrumbTrail(breadCrumbTrail);
                JMSPostie jmsPostie = new JMSPostie(rejectJMS.getQueueName(), rejectJMS.getConnectionFactory(), rejectJMS.getServersList());
                processor = new Processor();
                header = processor.getHeader((XmlObject)controlDocument);
                metaData = processor.getMetaData((XmlObject)controlDocument);
                jmsPostie.setConversationId(header.getConversationID());
                jmsPostie.setCorrelationId(metaData.getCapture().getID());
                jmsPostie.setLob(header.getLOB().toString());
                jmsPostie.setMessageClass(metaData.getMessageClass());
                jmsPostie.send(controlDocument.newCursor().xmlText());
            } else if (channel.isSetHTTP()) {
                ResponseRouteDocument.ResponseRoute.Channel.HTTP http = channel.getHTTP();
                ResponseRouteDocument.ResponseRoute.Channel.HTTP.Reject rejectHttp = http.getReject();
                HTTPPostie httpPostie = new HTTPPostie(rejectHttp.getURI(), rejectHttp.getPort(), rejectHttp.getMachine());
                httpPostie.send(StringUtils.convertStringToInputStream(controlDocument.xmlText()));
            } else if (channel.isSetJDBC()) {
                ResponseRouteDocument.ResponseRoute.Channel.JDBC jdbc = channel.getJDBC();
                ResponseRouteDocument.ResponseRoute.Channel.JDBC.Reject rejectJDBC = jdbc.getReject();
                JDBCPostie jdbcPostie = new JDBCPostie(rejectJDBC.getTable().getName(), rejectJDBC.getTable().getKeyColumn(), rejectJDBC.getTable().getDataColumn(), rejectJDBC.getDatasource());
                jdbcPostie.send(StringUtils.convertStringToInputStream(controlDocument.xmlText()), key);
            }
        }
        catch (Exception e) {
            throw new PostieException(e.getMessage(), e);
        }
    }

    @Override
    public void releaseResources() throws ResourceHandlerException {
        for (int x = 0; x < this.httpPosties.size(); ++x) {
            this.httpPosties.get(x).releaseResources();
        }
    }

    private Calendar getCurrentTimestampAsCalender() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.clear(15);
        return calendar;
    }
}

