/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.posties;

import org.apache.xmlbeans.XmlObject;
import uk.gov.hmrc.chRIS.service.control.ControlDocumentDocument1;
import uk.gov.hmrc.chRIS.service.control.header.HeaderDocument;
import uk.gov.hmrc.chRIS.service.control.metaData.MetaDataDocument;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.utils.config.ChRISNode;
import uk.gov.hmrc.chris.utils.config.ConfigUtils;
import uk.gov.hmrc.chris.utils.controldocument.Processor;
import uk.gov.hmrc.chris.utils.posties.PostieException;
import uk.gov.hmrc.chris.utils.posties.jms.JMSPostie;

public class RobustResponder {
    private static final String SERVICE_CONFIG_NAMESPACE = "http://www.hmrc.gov.uk/ChRIS/Service/Configuration/Robust";
    private ChRISNode config;

    public RobustResponder(ChRISNode config) {
        this.config = config.getNamespace(SERVICE_CONFIG_NAMESPACE);
        if (this.config == null) {
            throw new PostieException("No Robust configuration found in the supplied ChRISNode.", null);
        }
    }

    public void send(ControlDocumentDocument1.ControlDocument controlDoc) {
        Processor processor = null;
        HeaderDocument.Header header = null;
        MetaDataDocument.MetaData metaData = null;
        ChRISNode[] jmsConfig = null;
        String queueName = null;
        try {
            jmsConfig = this.config.getXPaths("JMS");
            processor = new Processor();
            header = processor.getHeader((XmlObject)controlDoc);
            metaData = processor.getMetaData((XmlObject)controlDoc);
            for (ChRISNode node : jmsConfig) {
                queueName = node.getXPath("QueueName").getValue();
                String connectionFactory = node.getXPath("ConnectionFactory").getValue();
                String serverList = ConfigUtils.getValue(node.getXPath("ServerList"));
                JMSPostie jmsPostie = new JMSPostie(queueName, connectionFactory, serverList);
                jmsPostie.setConversationId(header.getConversationID());
                jmsPostie.setCorrelationId(metaData.getCapture().getID());
                jmsPostie.setLob(header.getLOB().toString());
                jmsPostie.setMessageClass(metaData.getMessageClass());
                jmsPostie.send(controlDoc.newCursor().xmlText());
            }
        }
        catch (Exception e) {
            throw new PostieException("Exception publishing message to queue: " + queueName, e);
        }
        ChRISLogger.warning("Message written to Robust Q: " + queueName + " for CorrelationID=" + metaData.getCapture().getID() + ", ConversationID=" + header.getConversationID() + ", LOB=" + header.getLOB().toString() + ", MessageClass=" + metaData.getMessageClass());
    }
}

