/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.posties.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import uk.gov.hmrc.chris.ChRISBaseLogger;
import uk.gov.hmrc.chris.utils.connector.messagecontext.IMessageContext;
import uk.gov.hmrc.chris.utils.connector.messagecontext.MessageContextUtil;
import uk.gov.hmrc.chris.utils.logging.AccessLogMessageDetails;
import uk.gov.hmrc.chris.utils.logging.ChrisLogFactory;
import uk.gov.hmrc.chris.utils.posties.PostieException;
import uk.gov.hmrc.chris.utils.posties.http.ChrisHttpMethodRetryHandler;
import uk.gov.hmrc.chris.utils.posties.http.HTTPPostieHeader;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandler;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandlerException;

public class HTTPPostie
implements ResourceHandler {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String CONTENT_TYPE = "Content-Type";
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String SOAP_CONTENT_TYPE = "application/soap+xml";
    private InputStream results;
    private String machine;
    private String port;
    private String uri;
    private boolean chunked = true;
    private String protocol;
    private String contentType;
    private HTTPPostieHeader headers;
    private static final int DEFAULT_TIMEOUT = 60000;

    public HTTPPostie(String URI2, String port, String machine) {
        this(URI2, port, machine, true);
    }

    public HTTPPostie(String pURI, String pPort, String pMachine, boolean pChunked) {
        this.uri = pURI;
        this.port = pPort;
        this.machine = pMachine;
        this.chunked = pChunked;
    }

    public static Map<String, Object> postMessage(InputStream msg, String url) throws Exception {
        return HTTPPostie.postMessage(msg, url, XML_CONTENT_TYPE);
    }

    public static Map<String, Object> postMessage(InputStream msg, String url, String contentType) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (url == null || msg == null) {
            throw new NullPointerException("The supplied InputStream, URL or both are null\nSupplied URL is: " + url);
        }
        if (url.toLowerCase().indexOf(HTTP_PROTOCOL) == -1) {
            url = HTTP_PROTOCOL + url;
        }
        AccessLogMessageDetails accessLogMessageDetails = new AccessLogMessageDetails("HTTPPostie", "HTTPPostie", url);
        HttpClient client = new HttpClient();
        client.setConnectionTimeout(60000);
        client.setTimeout(60000);
        PostMethod post = new PostMethod(url);
        ChrisHttpMethodRetryHandler retryHandler = new ChrisHttpMethodRetryHandler();
        post.setRequestHeader(CONTENT_TYPE, contentType + "; charset=UTF-8");
        post.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
        post.setRequestBody(msg);
        int statusCode = client.executeMethod((HttpMethod)post);
        IMessageContext messageContext = MessageContextUtil.getMessageContext();
        if (messageContext != null) {
            ChrisLogFactory.logAccess(messageContext.getLob(), messageContext.getMessageClass(), accessLogMessageDetails);
        }
        responseData.put("responseCode", statusCode);
        responseData.put("httpResponse", post.getResponseBodyAsStream());
        return responseData;
    }

    public InputStream send(InputStream data, HTTPPostieHeader header) {
        String url = this.machine + ":" + this.port + "/" + this.uri;
        AccessLogMessageDetails accessLogMessageDetails = new AccessLogMessageDetails("HTTPPostie", "HTTPPostie", this.uri);
        try {
            int statusCode;
            HttpClient client = new HttpClient();
            client.setConnectionTimeout(60000);
            client.setTimeout(60000);
            PostMethod post = new PostMethod(url);
            post.setRequestHeader("Content-type", "text/xml; charset=UTF-8");
            this.setPostHeader(post, header);
            post.setRequestBody(data);
            if (this.chunked) {
                post.setRequestContentLength(-1L);
            }
            if ((statusCode = client.executeMethod((HttpMethod)post)) < 200 || statusCode >= 300) {
                accessLogMessageDetails.markAsFailed();
                throw new HttpPostieException(statusCode, "Message could not be sent to uri: " + url + ".  Status code was: " + statusCode, null);
            }
            this.results = post.getResponseBodyAsStream();
            ChRISBaseLogger.info("Message placed sent to URI: " + url);
        }
        catch (HttpException e) {
            accessLogMessageDetails.markAsFailed();
            throw new HttpPostieException("HTTP Exception on uri: " + url, e);
        }
        catch (IOException e) {
            accessLogMessageDetails.markAsFailed();
            throw new HttpPostieException("IO Exception with InputStream.  URL was : " + url, e);
        }
        finally {
            IMessageContext messageContext = MessageContextUtil.getMessageContext();
            if (messageContext != null) {
                ChrisLogFactory.logAccess(messageContext.getLob(), messageContext.getMessageClass(), accessLogMessageDetails);
            }
        }
        return this.results;
    }

    public InputStream send(InputStream data) {
        return this.send(data, null);
    }

    public Map<String, Object> postMessage(InputStream msg) throws HttpPostieException {
        String context = "Protocol: " + this.protocol + ", Machine: " + this.machine + ", Port: " + this.port + ", Path: " + this.uri;
        AccessLogMessageDetails accessLogMessageDetails = new AccessLogMessageDetails("HTTPPostie", "HTTPPostie", this.uri);
        try {
            String clientHost;
            HttpClient client = new HttpClient();
            client.getParams().setParameter("http.socket.timeout", (Object)60000);
            client.getParams().setParameter("http.connection.timeout", (Object)60000);
            String clientProtocol = this.protocol;
            int index = clientProtocol.indexOf("://");
            if (index != -1) {
                clientProtocol = clientProtocol.substring(0, index);
            }
            if ((index = (clientHost = this.machine).indexOf("://")) != -1) {
                clientHost = clientHost.substring(index + 3);
            }
            int clientPort = Integer.parseInt(this.port);
            String clientPath = this.uri;
            if (!clientPath.startsWith("/")) {
                clientPath = "/" + clientPath;
            }
            URI clientUri = new URI(clientProtocol, null, clientHost, clientPort, clientPath, null, null);
            PostMethod post = new PostMethod(clientUri.toString());
            post.setContentChunked(this.chunked);
            post.setRequestHeader(CONTENT_TYPE, this.contentType + "; charset=UTF-8");
            for (Map.Entry<String, String> header : this.headers.getHeaders().entrySet()) {
                post.setRequestHeader(header.getKey(), header.getValue());
            }
            InputStreamRequestEntity entity = new InputStreamRequestEntity(msg);
            post.setRequestEntity((RequestEntity)entity);
            int statusCode = client.executeMethod((HttpMethod)post);
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("responseCode", statusCode);
            responseData.put("httpResponse", post.getResponseBodyAsStream());
            HashMap<String, Object> hashMap = responseData;
            return hashMap;
        }
        catch (URISyntaxException e) {
            accessLogMessageDetails.markAsFailed();
            throw new HttpPostieException("The provided URI is not valid for " + context, e);
        }
        catch (HttpException e) {
            accessLogMessageDetails.markAsFailed();
            throw new HttpPostieException("HTTP problem as been generated by the http client for " + context, e);
        }
        catch (IOException e) {
            accessLogMessageDetails.markAsFailed();
            throw new HttpPostieException("IO problem while posting for " + context, e);
        }
        catch (Exception e) {
            accessLogMessageDetails.markAsFailed();
            throw new HttpPostieException("Generic problem while posting for " + context, e);
        }
        finally {
            IMessageContext messageContext = MessageContextUtil.getMessageContext();
            if (messageContext != null) {
                ChrisLogFactory.logAccess(messageContext.getLob(), messageContext.getMessageClass(), accessLogMessageDetails);
            }
        }
    }

    @Override
    public void releaseResources() throws ResourceHandlerException {
    }

    private void setPostHeader(PostMethod post, HTTPPostieHeader headers) {
        if (headers != null) {
            Map<String, String> keyValuePairs = headers.getHeaders();
            for (String key : keyValuePairs.keySet()) {
                post.setRequestHeader(key, keyValuePairs.get(key));
            }
        }
    }

    public static class Builder {
        private final String machine;
        private final String port;
        private final String uri;
        private boolean chunked = false;
        private String protocol = "http://";
        private String contentType = "text/xml";
        private HTTPPostieHeader headers = new HTTPPostieHeader();

        public Builder(String machine, String port, String uri) {
            this.machine = machine;
            this.port = port;
            this.uri = uri;
        }

        public Builder chunked(boolean chunked) {
            this.chunked = chunked;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.addheader(key, value);
            return this;
        }

        public HTTPPostie build() {
            HTTPPostie httpPostie = new HTTPPostie(this.uri, this.port, this.machine);
            httpPostie.chunked = this.chunked;
            httpPostie.protocol = this.protocol;
            httpPostie.contentType = this.contentType;
            httpPostie.headers = this.headers;
            return httpPostie;
        }
    }

    public class HttpPostieException
    extends PostieException {
        private int responseErrorCode;
        private static final long serialVersionUID = 1L;

        public HttpPostieException(int responseErrorCode, String message, Throwable exception) {
            super(message, exception);
            this.responseErrorCode = responseErrorCode;
        }

        public HttpPostieException(String message, Throwable exception) {
            super(message, exception);
        }

        public Integer getResponseErrorCode() {
            return this.responseErrorCode;
        }
    }
}

