/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.posties.jms;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.utils.JNDIUsage.JNDIUsage;
import uk.gov.hmrc.chris.utils.posties.PostieException;

public class BaseJMSPostie {
    private static String JNDI_PROVIDER_URL_PROTOCOL = "t3://";
    private static final String COMPONENT_CONTEXT_PREFIX = "java:comp/env/";
    private String connFactoryName;
    private String queueName;
    private String serversList;
    private String url;

    public BaseJMSPostie(String queueName, String connFactoryName, String serversList) {
        if (serversList == null || serversList.trim().length() == 0) {
            this.init(queueName, connFactoryName);
        } else {
            this.queueName = queueName;
            this.connFactoryName = connFactoryName;
            this.url = JNDI_PROVIDER_URL_PROTOCOL + serversList;
            ChRISLogger.info("serversList specified, making remote JMS Connection. This should be refactored to use JMS wrappers:" + this.toString());
        }
    }

    public BaseJMSPostie(String queueName, String connFactoryName) {
        this.init(queueName, connFactoryName);
    }

    public void init(String queueName, String connFactoryName) {
        this.queueName = COMPONENT_CONTEXT_PREFIX + queueName;
        this.connFactoryName = COMPONENT_CONTEXT_PREFIX + connFactoryName;
        ChRISLogger.info("serversList null or blank, using local component context to look up queue and connection factory:" + this.toString());
    }

    public void send(String data) {
        this.send(data, null);
    }

    public void send(String data, Map<String, String> headers) {
        this.send(data, headers, null);
    }

    public void send(String data, Map<String, String> headers, Integer jmsPriority) {
        ChRISLogger.info("JMS Postie to send message: " + data);
        QueueConnection qConn = null;
        QueueSession qSession = null;
        QueueSender sender = null;
        try {
            Queue queue;
            QueueConnectionFactory queueConnFac;
            Context context = JNDIUsage.getInstance().getInitialContext(this.url);
            try {
                queueConnFac = (QueueConnectionFactory)context.lookup(this.connFactoryName);
            }
            catch (NamingException e) {
                throw new PostieException("Naming Exception on context lookup of Connection Factory: " + this.connFactoryName, e);
            }
            qConn = queueConnFac.createQueueConnection();
            qSession = qConn.createQueueSession(false, 1);
            try {
                queue = (Queue)context.lookup(this.queueName);
            }
            catch (NamingException e) {
                throw new PostieException("Naming Exception on context lookup of Queue: " + this.queueName, e);
            }
            sender = qSession.createSender(queue);
            TextMessage textMessage = qSession.createTextMessage(data);
            if (jmsPriority != null) {
                textMessage.setJMSPriority(jmsPriority.intValue());
                sender.setPriority(jmsPriority.intValue());
            }
            this.setHeaders(headers, textMessage);
            sender.send((Message)textMessage);
            ChRISLogger.info("Message placed on queue: " + this.queueName);
        }
        catch (JMSException e) {
            throw new PostieException("JMS Exception occurred.", e);
        }
        finally {
            if (sender != null) {
                try {
                    sender.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close Sender.", e);
                }
            }
            if (qSession != null) {
                try {
                    qSession.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueSession.", e);
                }
            }
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueConnection.", e);
                }
            }
        }
    }

    private void setHeaders(Map<String, String> headers, TextMessage textMessage) throws JMSException {
        if (headers != null) {
            for (String key : headers.keySet()) {
                textMessage.setStringProperty(key, headers.get(key));
            }
        }
    }
}

