/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.posties.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.utils.JNDIUsage.JNDIUsage;
import uk.gov.hmrc.chris.utils.posties.PostieException;
import uk.gov.hmrc.chris.utils.transaction.JTATransactionCoordinator;

public class JMSPostie {
    private static final String JNDI_PROVIDER_URL_PROTOCOL = "t3://";
    private static final String COMPONENT_CONTEXT_PREFIX = "java:comp/env/";
    private String connFactoryName;
    private String queueName;
    private String url;
    private String lob;
    private String conversationId;
    private String correlationId;
    private String messageClass;
    private String controldocument;
    private String retryConvID;
    private String originalConvID;
    private String invocationContext;
    private String route;

    public JMSPostie(String queueName, String connFactoryName, String serversList) {
        if (serversList == null || serversList.trim().length() == 0) {
            this.init(queueName, connFactoryName);
        } else {
            this.queueName = queueName;
            this.connFactoryName = connFactoryName;
            this.url = JNDI_PROVIDER_URL_PROTOCOL + serversList;
            ChRISLogger.info("serversList specified, making remote JMS Connection. This should be refactored to use JMS wrappers:" + this.toString());
        }
    }

    public JMSPostie(String queueName, String connFactoryName) {
        this.init(queueName, connFactoryName);
    }

    public void init(String queueName, String connFactoryName) {
        this.queueName = COMPONENT_CONTEXT_PREFIX + queueName;
        this.connFactoryName = COMPONENT_CONTEXT_PREFIX + connFactoryName;
        ChRISLogger.info("serversList null or blank, using local component context to look up queue and connection factory:" + this.toString());
    }

    public String toString() {
        return "JMSPostie: url=" + this.url + ", queueName=" + this.queueName + ", connFactory=" + this.connFactoryName;
    }

    public void setControlDocument(String controlDocument) {
        this.controldocument = controlDocument;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setLob(String lob) {
        this.lob = lob;
    }

    public void setMessageClass(String messageClass) {
        this.messageClass = messageClass;
    }

    public void setRetryConvID(String retryConvID) {
        this.retryConvID = retryConvID;
    }

    public void setOriginalConvID(String originalConvID) {
        this.originalConvID = originalConvID;
    }

    public void setInvocationContext(String invocationContext) {
        this.invocationContext = invocationContext;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void send(String data) {
        ChRISLogger.info("JMS Postie to send message: " + data);
        QueueConnection qConn = null;
        QueueSession qSession = null;
        QueueSender sender = null;
        try {
            Queue queue;
            QueueConnectionFactory queueConnFac;
            JTATransactionCoordinator.notifyTransactionRequired();
            Context context = JNDIUsage.getInstance().getInitialContext(this.url);
            try {
                queueConnFac = (QueueConnectionFactory)context.lookup(this.connFactoryName);
            }
            catch (NamingException e) {
                throw new PostieException("Naming Exception on context lookup of Connection Factory: " + this.connFactoryName, e);
            }
            qConn = queueConnFac.createQueueConnection();
            qSession = qConn.createQueueSession(false, 1);
            try {
                queue = (Queue)context.lookup(this.queueName);
                ChRISLogger.debug("Got JMS QueueConnectionFactory for " + this.connFactoryName + ":" + queueConnFac.getClass().getName());
                ChRISLogger.debug("Got JMS QueueConnection for " + this.queueName + ":" + qConn.getClass().getName());
                ChRISLogger.debug("Got JMS Queue for " + this.queueName + ":" + queue.getClass().getName());
            }
            catch (NamingException e) {
                throw new PostieException("Naming Exception on context lookup of Queue: " + this.queueName, e);
            }
            sender = qSession.createSender(queue);
            TextMessage textMessage = qSession.createTextMessage(data);
            if (this.correlationId != null) {
                textMessage.setJMSCorrelationID(this.correlationId);
            }
            if (this.conversationId != null) {
                textMessage.setStringProperty("CONVERSATION_ID", this.conversationId);
            }
            if (this.messageClass != null) {
                textMessage.setStringProperty("MESSAGE_CLASS", this.messageClass);
            }
            if (this.lob != null) {
                textMessage.setStringProperty("LOB", this.lob);
            }
            if (this.route != null) {
                textMessage.setStringProperty("ROUTE", this.route);
            }
            if (this.retryConvID != null) {
                textMessage.setStringProperty("RETRY_CONVID", this.retryConvID);
            }
            if (this.originalConvID != null) {
                textMessage.setStringProperty("Original_ConvID", this.originalConvID);
            }
            if (this.invocationContext != null) {
                textMessage.setStringProperty("INVOCATION_CONTEXT", this.invocationContext);
            }
            if (this.controldocument != null) {
                textMessage.setStringProperty("CONTROL_DOCUMENT", this.controldocument);
            }
            sender.send((Message)textMessage);
            ChRISLogger.info("Message placed on queue: " + this.queueName);
        }
        catch (JMSException e) {
            throw new PostieException("JMS Exception occurred.", e);
        }
        finally {
            if (sender != null) {
                try {
                    sender.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close Sender.", e);
                }
            }
            if (qSession != null) {
                try {
                    qSession.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueSession.", e);
                }
            }
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueConnection.", e);
                }
            }
        }
    }
}

