/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.posties.utm;

import ir.middleware.TransferManager.TransferManager;
import java.io.File;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.utils.posties.PostieException;

public class UTMPostie {
    private String sendingApplication;
    private String receivingSystem;
    private String receivingTarget;
    private String targetFile;
    private String transferType;
    private String actionOnTransfer;
    private String priority;
    private String directDataIndicator;
    private String trackingRequired;
    private String postTransferHook;
    private String postCompletionHook;
    private String retainFile;
    private String tapeTransfer;

    public void transferFile(File transferee) {
        ChRISLogger.info("Sending " + transferee.getAbsolutePath() + " through transfer manager with the following settings:" + "\nSending Application: " + this.sendingApplication + "\nReceiving System: " + this.receivingSystem + "\nReceiving Target: " + this.receivingTarget + "\nTarget File: " + this.targetFile + "\nTransfer Type: " + this.transferType + "\nAction on Transfer: " + this.actionOnTransfer + "\nPriority: " + this.priority + "\nDirect Date Indicator: " + this.directDataIndicator + "\nTracking required: " + this.trackingRequired + "\nPost Transfer Hook: " + this.postTransferHook + "\nPost Completion Hook: " + this.postCompletionHook + "\nRetain file: " + this.retainFile + "\nTape Transfer: " + this.tapeTransfer);
        try {
            TransferManager.irTransferFile((String)this.sendingApplication, (String)transferee.getAbsolutePath(), (String)this.receivingSystem, (String)this.receivingTarget, (String)this.targetFile, (String)this.transferType, (String)this.actionOnTransfer, (String)this.priority, (String)this.directDataIndicator, (String)this.trackingRequired, (String)this.postTransferHook, (String)this.postCompletionHook, (String)this.retainFile, (String)this.tapeTransfer);
        }
        catch (Exception e) {
            ChRISLogger.info("UTMPostie - Call to Transfer Manager failed");
            throw new PostieException("Unable to deliver the file " + transferee.getName() + " to Unix Transfer Manager", e);
        }
    }

    public void setActionOnTransfer(String actionOnTransfer) {
        this.actionOnTransfer = actionOnTransfer;
    }

    public void setDirectDataIndicator(String directDataIndicator) {
        this.directDataIndicator = directDataIndicator;
    }

    public void setPostCompletionHook(String postCompletionHook) {
        this.postCompletionHook = postCompletionHook;
    }

    public void setPostTransferHook(String postTransferHook) {
        this.postTransferHook = postTransferHook;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setReceivingSystem(String receivingSystem) {
        this.receivingSystem = receivingSystem;
    }

    public void setReceivingTarget(String receivingTarget) {
        this.receivingTarget = receivingTarget;
    }

    public void setRetainFile(String retainFile) {
        this.retainFile = retainFile;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public void setTapeTransfer(String tapeTransfer) {
        this.tapeTransfer = tapeTransfer;
    }

    public void setTrackingRequired(String trackingRequired) {
        this.trackingRequired = trackingRequired;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }
}

