/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.receivers.jms;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import uk.gov.hmrc.chris.utils.JNDIUsage.JNDIUsage;
import uk.gov.hmrc.chris.utils.posties.PostieException;
import uk.gov.hmrc.chris.utils.receivers.ReceiverException;

public class JMSReceiver {
    private String connFactoryName;
    private String queueName;
    private String url;

    public JMSReceiver(String queueName, String connFactoryName) {
        this.queueName = queueName;
        this.connFactoryName = connFactoryName;
        this.url = null;
    }

    public JMSReceiver(String queueName, String connFactoryName, String url) {
        this.queueName = queueName;
        this.connFactoryName = connFactoryName;
        this.url = url;
    }

    public Message receive(String key) throws ReceiverException {
        QueueConnection qConn = null;
        QueueSession qSession = null;
        QueueReceiver receiver = null;
        try {
            Context context = JNDIUsage.getInstance().getInitialContext("t3://" + this.url);
            QueueConnectionFactory queueConnFac = (QueueConnectionFactory)context.lookup(this.connFactoryName);
            qConn = queueConnFac.createQueueConnection();
            qSession = qConn.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(this.queueName);
            String selector = "JMSCorrelationID = '" + key + "'";
            receiver = qSession.createReceiver(queue, selector);
            qConn.start();
            TextMessage message = (TextMessage)receiver.receive(300000L);
            Message message2 = this.loadMessages(message);
            return message2;
        }
        catch (NamingException e) {
            throw new ReceiverException("Could not deal with the context.  Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        catch (JMSException e) {
            throw new ReceiverException("Problem with communcitaions with JMS. Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        finally {
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueConnection.", e);
                }
            }
            if (receiver != null) {
                try {
                    receiver.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close Sender.", e);
                }
            }
            if (qSession != null) {
                try {
                    qSession.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueSession.", e);
                }
            }
        }
    }

    private Message loadMessages(TextMessage item) throws JMSException {
        Message jmsMessage = null;
        if (item != null) {
            jmsMessage = new Message();
            jmsMessage.setConversationId(item.getStringProperty("CONVERSATION_ID"));
            jmsMessage.setCorrelationId(item.getJMSCorrelationID());
            jmsMessage.setMessageClass(item.getStringProperty("MESSAGE_CLASS"));
            jmsMessage.setLob(item.getStringProperty("LOB"));
            jmsMessage.setMessage(item.getText());
            jmsMessage.setTimestamp(new Date(item.getJMSTimestamp()));
            Enumeration properties = item.getPropertyNames();
            while (properties.hasMoreElements()) {
                String property = (String)properties.nextElement();
                String value = item.getStringProperty(property);
                jmsMessage.addProperty(property, value);
            }
        }
        return jmsMessage;
    }

    public Message[] browse(String selector) throws ReceiverException {
        QueueConnection qConn = null;
        QueueSession qSession = null;
        QueueBrowser receiver = null;
        try {
            Context context = JNDIUsage.getInstance().getInitialContext("t3://" + this.url);
            QueueConnectionFactory queueConnFac = (QueueConnectionFactory)context.lookup(this.connFactoryName);
            qConn = queueConnFac.createQueueConnection();
            qSession = qConn.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(this.queueName);
            receiver = qSession.createBrowser(queue, selector);
            qConn.start();
            Enumeration message = receiver.getEnumeration();
            ArrayList<Message> messages = new ArrayList<Message>();
            while (message.hasMoreElements()) {
                TextMessage item = (TextMessage)message.nextElement();
                Message jmsMessage = this.loadMessages(item);
                if (jmsMessage == null) continue;
                messages.add(jmsMessage);
            }
            Message[] messageArray = messages.toArray(new Message[messages.size()]);
            return messageArray;
        }
        catch (NamingException e) {
            throw new ReceiverException("Could not deal with the context.  Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        catch (JMSException e) {
            throw new ReceiverException("Problem with communcitaions with JMS. Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        finally {
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueConnection.", e);
                }
            }
            if (receiver != null) {
                try {
                    receiver.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close Sender.", e);
                }
            }
            if (qSession != null) {
                try {
                    qSession.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueSession.", e);
                }
            }
        }
    }

    public Message[] browse() throws ReceiverException {
        QueueConnection qConn = null;
        QueueSession qSession = null;
        QueueBrowser receiver = null;
        try {
            Context context = JNDIUsage.getInstance().getInitialContext("t3://" + this.url);
            QueueConnectionFactory queueConnFac = (QueueConnectionFactory)context.lookup(this.connFactoryName);
            qConn = queueConnFac.createQueueConnection();
            qSession = qConn.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(this.queueName);
            receiver = qSession.createBrowser(queue);
            qConn.start();
            Enumeration message = receiver.getEnumeration();
            ArrayList<Message> messages = new ArrayList<Message>();
            while (message.hasMoreElements()) {
                TextMessage item = (TextMessage)message.nextElement();
                Message jmsMessage = this.loadMessages(item);
                if (jmsMessage == null) continue;
                messages.add(jmsMessage);
            }
            Message[] messageArray = messages.toArray(new Message[messages.size()]);
            return messageArray;
        }
        catch (NamingException e) {
            throw new ReceiverException("Could not deal with the context.  Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        catch (JMSException e) {
            throw new ReceiverException("Problem with communcitaions with JMS. Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        finally {
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueConnection.", e);
                }
            }
            if (receiver != null) {
                try {
                    receiver.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close Sender.", e);
                }
            }
            if (qSession != null) {
                try {
                    qSession.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueSession.", e);
                }
            }
        }
    }

    public Message receive() throws ReceiverException {
        QueueConnection qConn = null;
        QueueSession qSession = null;
        QueueReceiver receiver = null;
        try {
            Context context = JNDIUsage.getInstance().getInitialContext("t3://" + this.url);
            QueueConnectionFactory queueConnFac = (QueueConnectionFactory)PortableRemoteObject.narrow((Object)context.lookup(this.connFactoryName), QueueConnectionFactory.class);
            qConn = queueConnFac.createQueueConnection();
            qSession = qConn.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(this.queueName);
            receiver = qSession.createReceiver(queue);
            qConn.start();
            TextMessage message = (TextMessage)receiver.receive(300000L);
            Message message2 = this.loadMessages(message);
            return message2;
        }
        catch (NamingException e) {
            throw new ReceiverException("Could not deal with the context.  Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        catch (JMSException e) {
            throw new ReceiverException("Problem with communcitaions with JMS. Could not connect to t3://" + this.url + ".  To Queue: " + this.queueName + " with connection factory " + this.connFactoryName, e);
        }
        finally {
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueConnection.", e);
                }
            }
            if (receiver != null) {
                try {
                    receiver.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close Sender.", e);
                }
            }
            if (qSession != null) {
                try {
                    qSession.close();
                }
                catch (JMSException e) {
                    throw new PostieException("Unable to close QueueSession.", e);
                }
            }
        }
    }

    public class Message {
        private Date timestamp;
        private String lob;
        private String conversationId;
        private String correlationId;
        private String messageClass;
        private String message;
        private HashMap<String, String> properties = new HashMap();

        public String getConversationId() {
            return this.conversationId;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public String getLob() {
            return this.lob;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageClass() {
            return this.messageClass;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        private void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        private void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        private void setLob(String lob) {
            this.lob = lob;
        }

        private void setMessage(String message) {
            this.message = message;
        }

        private void setMessageClass(String messageClass) {
            this.messageClass = messageClass;
        }

        private void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        private void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public String[] getPropertyKeys() {
            return this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
        }
    }
}

