/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.resoucehandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.gov.hmrc.chris.ChRISBaseLogger;

public class CloseResourcesUtils {
    public static void close(OutputStream out) {
        CloseResourcesUtils.close(out, false);
    }

    public static void close(InputStream in) {
        CloseResourcesUtils.close(in, false);
    }

    public static void close(OutputStream out, boolean throwException) {
        try {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (IOException e) {
            if (throwException) {
                throw new CloseResourcesException("Exception occurred while closing an output stream", e);
            }
            ChRISBaseLogger.warning("Exception occurred while closing an output stream: " + e);
        }
    }

    public static void close(InputStream in, boolean throwException) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            if (throwException) {
                throw new CloseResourcesException("Exception occurred while closing an input stream", e);
            }
            ChRISBaseLogger.warning("Exception occurred while closing an input stream: " + e);
        }
    }

    public static class CloseResourcesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CloseResourcesException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

