/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.resoucehandler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.SystemException;
import uk.gov.hmrc.chris.utils.JNDIUsage.JNDIUsage;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceForemanException;

public class ConnectionHandler {
    private Map<String, Connection> connections = Collections.synchronizedMap(new HashMap());

    ConnectionHandler() {
    }

    public PreparedStatement getPreparedStatement(String sql, String datasource) throws SQLException {
        try {
            return this.getConnection(datasource).prepareStatement(sql);
        }
        catch (ResourceForemanException e) {
            throw new SystemException("Unable to get connection to datasource: " + datasource, e);
        }
    }

    public CallableStatement getCallableStatement(String sql, String datasource) throws SQLException {
        try {
            return this.getConnection(datasource).prepareCall(sql);
        }
        catch (ResourceForemanException e) {
            throw new SystemException("Unable to get connection to datasource: " + datasource, e);
        }
    }

    protected Connection getConnection(String datasource) throws ResourceForemanException {
        if (this.connections.containsKey(datasource)) {
            return this.connections.get(datasource);
        }
        Connection conn = JNDIUsage.getInstance().getConnection(null, datasource);
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ResourceForemanException("Unable to set AutoCommit to false for connection on datasource: " + datasource, e);
        }
        this.connections.put(datasource, conn);
        return conn;
    }

    public String getDriverVersion(String datasource) {
        StringBuffer returnData = new StringBuffer();
        try {
            DatabaseMetaData meta = this.getConnection(datasource).getMetaData();
            returnData.append("JDBC driver version : ").append(meta.getDriverVersion()).append("\n");
        }
        catch (SQLException e) {
            ChRISLogger.info("Could not get the driver version: " + e.getMessage());
        }
        catch (ResourceForemanException e) {
            throw new SystemException("Unable to get connection to datasource: " + datasource, e);
        }
        return returnData.toString();
    }

    public synchronized void releaseResources() throws ResourceForemanException {
        boolean problemEncountered = false;
        for (Connection conn : this.connections.values()) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                problemEncountered = true;
                ChRISLogger.error("Could not close down connection.  Erorr was: " + e.getMessage());
            }
        }
        this.connections.clear();
        if (problemEncountered) {
            throw new ResourceForemanException("One or more connection had problem closing down.  System in unknown state");
        }
    }
}

