/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.resoucehandler;

import java.util.ArrayList;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.utils.ThreadLocalProxy;
import uk.gov.hmrc.chris.utils.resoucehandler.ConnectionHandler;
import uk.gov.hmrc.chris.utils.resoucehandler.NonXAConnectionHandler;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceForemanException;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandler;

public class ResourceForman {
    private ArrayList<ResourceHandler> handlers = new ArrayList();
    private ArrayList<ResourceHandler> longTermHandlers = new ArrayList();
    private ConnectionHandler connectionHandler = new ConnectionHandler();
    private NonXAConnectionHandler nonXAconnectionHandler = new NonXAConnectionHandler();
    private static final String THREAD_LOCAL_KEY = "RESOURCEFOREMAN";
    private boolean errorReleasingResource = false;

    private ResourceForman() {
    }

    public void addResourceHandler(ResourceHandler handler) {
        this.handlers.add(handler);
    }

    public void addLongTermResourceHandler(ResourceHandler handler) {
        this.longTermHandlers.add(handler);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public NonXAConnectionHandler getNonXAConnectionHandler() {
        return this.nonXAconnectionHandler;
    }

    public static ResourceForman getInstance() {
        Object object = ThreadLocalProxy.getThreadLocalObject(THREAD_LOCAL_KEY);
        ResourceForman foreman = null;
        if (object == null) {
            foreman = new ResourceForman();
            ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY, foreman);
        } else {
            foreman = (ResourceForman)object;
        }
        return foreman;
    }

    private void clearInstance() {
        Object object = ThreadLocalProxy.getThreadLocalObject(THREAD_LOCAL_KEY);
        if (object != null) {
            ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY, null);
        }
    }

    public void releaseResources() throws ResourceForemanException {
        for (int x = 0; x < this.handlers.size(); ++x) {
            String resource = null;
            try {
                ResourceHandler handler = this.handlers.get(x);
                if (handler != null) {
                    resource = handler.getClass().getName();
                    handler.releaseResources();
                }
                handler = null;
                continue;
            }
            catch (Exception e) {
                this.errorReleasingResource = true;
                ChRISLogger.error("Error releasing resource " + resource, e);
            }
        }
        this.handlers.clear();
        try {
            this.connectionHandler.releaseResources();
        }
        catch (Exception e) {
            this.errorReleasingResource = true;
            ChRISLogger.error("Error releasing connection handler", e);
        }
        try {
            this.nonXAconnectionHandler.releaseResources();
        }
        catch (Exception e) {
            this.errorReleasingResource = true;
            ChRISLogger.error("Error releasing non xa connection handler", e);
        }
        if (this.errorReleasingResource) {
            throw new ResourceForemanException("An error occured while releasing resources. Please look at the incident files associated with this error to diagnose the cause of the problem.");
        }
    }

    public void releaseLongTermResources() throws ResourceForemanException {
        this.errorReleasingResource = false;
        try {
            this.releaseResources();
        }
        catch (Exception ex) {
            this.errorReleasingResource = true;
        }
        for (int x = 0; x < this.longTermHandlers.size(); ++x) {
            String resource = null;
            try {
                ResourceHandler handler = this.longTermHandlers.get(x);
                if (handler != null) {
                    resource = handler.getClass().getName();
                    handler.releaseResources();
                }
                handler = null;
                continue;
            }
            catch (Exception e) {
                this.errorReleasingResource = true;
                ChRISLogger.error("Error releasing long term resorce " + resource, e);
            }
        }
        this.longTermHandlers.clear();
        try {
            this.connectionHandler.releaseResources();
        }
        catch (Exception e) {
            this.errorReleasingResource = true;
        }
        try {
            this.nonXAconnectionHandler.releaseResources();
        }
        catch (Exception e) {
            this.errorReleasingResource = true;
        }
        this.clearInstance();
        if (this.errorReleasingResource) {
            throw new ResourceForemanException("An error occured while releasing long term resources. Please look at the incident files associated with this error to diagnose the cause of the problem.");
        }
    }
}

