/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.security;

import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import uk.gov.hmrc.chris.utils.config.ChRISConfig;
import uk.gov.hmrc.chris.utils.config.ChRISNode;
import uk.gov.hmrc.chris.utils.security.SecurityException;
import uk.gov.hmrc.chris.utils.security.SystemCredentials;
import uk.gov.hmrc.chris.utils.security.UserCredentials;
import uk.gov.inrev.realms.internal.X500Server;
import uk.gov.inrev.realms.internal.util.IRRole;

class SecurityCentral {
    private static final String X500NMSP = "http://www.hmrc.gov.uk/ChRIS/Service/Tracking/Configuration/X500";

    SecurityCentral() {
    }

    private static void loadIRRoles(UserCredentials credentials, Iterator roles) {
        while (roles.hasNext()) {
            IRRole role = (IRRole)roles.next();
            credentials.setRole(role.getName());
        }
    }

    private static void loadUserRoles(X500Server x500, UserCredentials credentials) throws SecurityException {
        try {
            NamingEnumeration enumProfiles = x500.lookupLdapPersonProfile(credentials.getPID());
            while (enumProfiles != null && enumProfiles.hasMore()) {
                SearchResult sr = (SearchResult)enumProfiles.next();
                Attributes profileAttributes = sr.getAttributes();
                Attribute attrProfile = profileAttributes.get("iRUserRoleDN");
                if (attrProfile == null) continue;
                NamingEnumeration<?> enumRoles = attrProfile.getAll();
                while (enumRoles != null && enumRoles.hasMore()) {
                    String role = (String)enumRoles.next();
                    int pos = role.indexOf("cn=");
                    if (pos == -1) continue;
                    if ((pos = (role = role.substring(pos + 3)).indexOf(",")) != -1) {
                        role = role.substring(0, pos);
                    }
                    role = role.trim();
                    credentials.setRole(role);
                    credentials.setUserRole(role);
                }
            }
        }
        catch (NamingException e) {
            throw new SecurityException("Could not use manual LDAP lookup", e);
        }
    }

    static void setUserCredentials(UserCredentials credentials) throws SecurityException {
        X500Server x500 = X500Server.getInstance();
        if (x500 != null) {
            SecurityCentral.loadIRRoles(credentials, x500.getMURoles(credentials.getPID()).iterator());
            SecurityCentral.loadIRRoles(credentials, x500.getOfficeRoles(credentials.getPID()).iterator());
            SecurityCentral.loadUserRoles(x500, credentials);
            credentials.setEmployeeDetails(x500.getUserDetails(credentials.getPID()));
        }
    }

    static SystemCredentials getSystemCredentials(String service) {
        ChRISNode[] nodes;
        SystemCredentials credentials = new SystemCredentials();
        ChRISNode x500Node = ChRISConfig.getNode("http://www.hmrc.gov.uk/ChRIS/Service/Tracking/Configuration/X500/" + service);
        for (ChRISNode node : nodes = x500Node.getXPaths("Security/Clearences/Value")) {
            credentials.setAcceptedRole(node.getValue());
        }
        return credentials;
    }
}

