/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.security;

import ir.middleware.Encrypt.Encrypt;
import uk.gov.hmrc.chRIS.service.userDetails.UserDetailsDocument;
import uk.gov.hmrc.chris.utils.security.SecurityCentral;
import uk.gov.hmrc.chris.utils.security.SecurityException;
import uk.gov.hmrc.chris.utils.security.SystemCredentials;
import uk.gov.hmrc.chris.utils.security.UserCredentials;

public class SecurityDesk {
    private static SystemCredentials systemCredentials;
    private UserCredentials userCredentials;

    public UserCredentials getUserDetails() {
        return this.userCredentials;
    }

    public boolean isAuthorised(UserDetailsDocument.UserDetails userDetails, String service) throws SecurityException {
        SecurityDesk.loadSytemCredentials(service);
        this.userCredentials = this.extractUserData(userDetails);
        SecurityCentral.setUserCredentials(this.userCredentials);
        String[] userCredentials = this.userCredentials.getRoles();
        for (int x = 0; x < userCredentials.length; ++x) {
            String credential = userCredentials[x];
            if (!systemCredentials.isRoleAccepted(credential)) continue;
            return true;
        }
        return false;
    }

    private static void loadSytemCredentials(String service) {
        if (systemCredentials == null) {
            systemCredentials = SecurityCentral.getSystemCredentials(service);
        }
    }

    private UserCredentials extractUserData(UserDetailsDocument.UserDetails userDetails) throws SecurityException {
        UserCredentials credentials = new UserCredentials();
        try {
            credentials.setPID(Encrypt.decrypt((String)userDetails.getPID()));
        }
        catch (Exception e) {
            throw new SecurityException("Could not decrypt user pid", e);
        }
        credentials.setIPAddress(userDetails.getIPAddress());
        return credentials;
    }
}

