/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ChainedInputStream
extends InputStream {
    private List<InputStream> inputStreams = new ArrayList<InputStream>();
    private int index = 0;

    public void add(InputStream inputStream) {
        this.inputStreams.add(inputStream);
    }

    @Override
    public int read() throws IOException {
        int b = this.inputStreams.get(this.index).read();
        if (b == -1 && this.index < this.inputStreams.size() - 1) {
            ++this.index;
            b = this.read();
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        boolean exception = false;
        for (InputStream inputStream : this.inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                exception = true;
            }
        }
        if (exception) {
            throw new IOException("An I/O exception was raised during the closure of at least one of the input streams");
        }
    }
}

