/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.streaming;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;

public class StreamHandler {
    private StreamHandler() {
    }

    public static int streamData(InputStream source, OutputStream destination) throws StreamingException {
        try {
            byte[] data = new byte[4096];
            int dataRead = 0;
            int dataSize = 0;
            while ((dataRead = source.read(data)) != -1) {
                destination.write(data, 0, dataRead);
                dataSize += dataRead;
            }
            destination.flush();
            return dataSize;
        }
        catch (IOException e) {
            throw new StreamingException("Could not find write to the stream", (Object)e);
        }
    }

    public static int streamData(InputStream source, OutputStream destination, String fileHeader, boolean forFirsttime) throws StreamingException {
        try {
            byte[] data = new byte[4096];
            int dataRead = 0;
            int dataSize = 0;
            if (forFirsttime) {
                byte[] byteFileHeader = fileHeader.getBytes("UTF-8");
                destination.write(byteFileHeader);
                destination.write(10);
            }
            while ((dataRead = source.read(data)) != -1) {
                destination.write(data, 0, dataRead);
                dataSize += dataRead;
            }
            destination.flush();
            return dataSize;
        }
        catch (IOException e) {
            throw new StreamingException("Could not find write to the stream", (Object)e);
        }
    }

    public static void streamData(Reader source, Writer destination) throws StreamingException {
        try {
            char[] data = new char[4096];
            int dataRead = 0;
            while ((dataRead = source.read(data)) != -1) {
                destination.write(data, 0, dataRead);
            }
            destination.flush();
        }
        catch (IOException e) {
            throw new StreamingException("Could not find write to the stream", (Object)e);
        }
    }

    public static int streamDataWithRecCount(InputStream source, OutputStream destination) throws StreamingException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(source), 4096);
            int recordCount = 0;
            boolean firstLine = true;
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(destination));
            while ((line = br.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    bw.newLine();
                }
                bw.write(line);
                ++recordCount;
            }
            bw.flush();
            return recordCount;
        }
        catch (IOException e) {
            throw new StreamingException("Could not find write to the stream", (Object)e);
        }
    }

    public static InputStream createBufferedInputStream(byte[] data) {
        return new BufferedInputStream(new ByteArrayInputStream(data));
    }

    public static Reader createBufferedReader(char[] data) {
        return new BufferedReader(new CharArrayReader(data));
    }
}

