/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;

public class StringUtils {
    public static String convertInputStreamToString(InputStream pInputStream) throws StreamingException {
        byte[] data = new byte[4096];
        int bytesRead = 0;
        StringBuffer destination = new StringBuffer();
        try {
            while ((bytesRead = pInputStream.read(data)) != -1) {
                destination.append(new String(data, 0, bytesRead, "UTF-8"));
            }
        }
        catch (IOException ioe) {
            throw new StreamingException("Unable to read from stream", (Object)ioe);
        }
        return destination.toString();
    }

    public static InputStream convertStringToInputStream(String data) throws StreamingException {
        if (data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            return new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamingException("Problem encoding string", (Object)e);
        }
    }

    public static byte[] convertStringToBytes(String data) throws UnsupportedEncodingException {
        return data.getBytes("UTF-8");
    }

    public static String convertReaderToString(Reader pSource) throws StreamingException {
        StringWriter destination = new StringWriter();
        char[] dataBytes = new char[4096];
        int bytesread = 0;
        try {
            while ((bytesread = pSource.read(dataBytes)) != -1) {
                ((Writer)destination).write(dataBytes, 0, bytesread);
            }
            ((Writer)destination).flush();
            ((Writer)destination).close();
        }
        catch (IOException e) {
            throw new StreamingException("Could not read in data", (Object)e);
        }
        return ((Object)destination).toString();
    }

    public static String covertToString(byte[] bytes, int start, int length) throws StreamingException {
        try {
            return new String(bytes, start, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamingException("Could not convert bytes to UTF8 string", (Object)e);
        }
    }

    public static String covertToString(byte[] bytes) throws StreamingException {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamingException("Could not convert bytes to UTF8 string", (Object)e);
        }
    }
}

