/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TokenisedInputStream
extends InputStream {
    private byte[] templateBytes;
    private TreeMap<Integer, Object> subStreams;
    private Iterator<Map.Entry<Integer, Object>> subStreamItr;
    private Map.Entry<Integer, Object> currentSubStreamEntry;
    private int currentSubStreamArrayIndex;
    private int templatePos = 0;
    private String templateEncoding;

    public TokenisedInputStream(String template, String templateEncoding, Map<String, InputStream> tokens) throws UnsupportedEncodingException {
        this.templateEncoding = templateEncoding;
        TreeMap<Integer, String> orderedTokens = this.sortTokensAccordingToTemplateOrder(template, tokens);
        this.populateTemplateAndSubStreams(template, orderedTokens, tokens);
        if (tokens.size() > 0) {
            this.subStreamItr = this.subStreams.entrySet().iterator();
            this.currentSubStreamEntry = this.subStreamItr.next();
            this.currentSubStreamArrayIndex = 0;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        if (this.isPositionInSubStream()) {
            int b = this.getCurrentSubStream().read();
            if (b != -1) {
                return b;
            }
            this.advanceSubStream();
            return this.read();
        }
        return this.templateBytes[this.templatePos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.isEndOfStream()) {
            return -1;
        }
        if (this.isPositionInSubStream()) {
            bytesRead = this.getCurrentSubStream().read(b, off, len);
            if (bytesRead == -1) {
                this.advanceSubStream();
                return this.read(b, off, len);
            }
        } else {
            int nextTokenPos;
            int n = nextTokenPos = this.currentSubStreamEntry == null ? -1 : this.currentSubStreamEntry.getKey();
            if (nextTokenPos != -1 && this.templatePos + len > nextTokenPos) {
                int copyLen = nextTokenPos - this.templatePos;
                this.copyTemplate(b, off, nextTokenPos);
                bytesRead = copyLen;
            } else {
                int templateLen = this.templateBytes.length;
                int endPos = this.templatePos + len > templateLen ? templateLen : this.templatePos + len;
                bytesRead = endPos - this.templatePos;
                this.copyTemplate(b, off, endPos);
            }
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        if (this.isPositionInSubStream()) {
            long availableToSkip = this.getCurrentSubStream().available();
            long amountToSkip = n;
            if (availableToSkip < n) {
                amountToSkip = availableToSkip;
            }
            return this.getCurrentSubStream().skip(amountToSkip);
        }
        if (this.currentSubStreamEntry != null && (long)this.templatePos + n > (long)this.currentSubStreamEntry.getKey().intValue()) {
            int skipped = this.currentSubStreamEntry.getKey() - this.templatePos;
            this.templatePos = this.currentSubStreamEntry.getKey();
            return skipped;
        }
        if ((long)this.templatePos + n >= (long)this.templateBytes.length) {
            this.templatePos = this.templateBytes.length;
            return n - (long)(this.templateBytes.length - this.templatePos);
        }
        this.templatePos = (int)((long)this.templatePos + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.isEndOfStream()) {
            return 0;
        }
        if (this.isPositionInSubStream()) {
            return this.getCurrentSubStream().available();
        }
        if (this.currentSubStreamEntry == null) {
            return this.templateBytes.length - this.templatePos;
        }
        int nextTokenPos = this.currentSubStreamEntry.getKey();
        return nextTokenPos - this.templatePos;
    }

    @Override
    public void close() throws IOException {
        for (Object subStreamEntryVal : this.subStreams.values()) {
            if (subStreamEntryVal instanceof InputStream) {
                ((InputStream)subStreamEntryVal).close();
                continue;
            }
            if (subStreamEntryVal instanceof ArrayList) {
                ArrayList l = (ArrayList)subStreamEntryVal;
                for (int i = 0; i < l.size(); ++i) {
                    InputStream is = (InputStream)l.get(i);
                    is.close();
                }
                continue;
            }
            throw new AssertionError(subStreamEntryVal.getClass());
        }
    }

    @Override
    public synchronized void mark(int readLimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark/reset not supported. Clients should call markSupported before calling this method to check if this method is implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void copyTemplate(byte[] b, int off, int endTemplatePos) throws IOException {
        int i = 0;
        while (this.templatePos < endTemplatePos) {
            b[i + off] = this.templateBytes[this.templatePos];
            ++i;
            ++this.templatePos;
        }
    }

    private TreeMap<Integer, String> sortTokensAccordingToTemplateOrder(String template, Map<String, InputStream> tokens) {
        TreeMap<Integer, String> orderedTokens = new TreeMap<Integer, String>(new TokenPositionComparator());
        for (Map.Entry<String, InputStream> token : tokens.entrySet()) {
            String tokenString = token.getKey();
            int pos = template.indexOf(tokenString);
            if (pos == -1) {
                throw new IllegalArgumentException("Unable to find token " + tokenString + " in template");
            }
            orderedTokens.put(pos, token.getKey());
        }
        return orderedTokens;
    }

    private void populateTemplateAndSubStreams(String template, TreeMap<Integer, String> orderedTokens, Map<String, InputStream> tokens) throws UnsupportedEncodingException {
        this.subStreams = new TreeMap(new TokenPositionComparator());
        StringByteBuffer sbb = new StringByteBuffer(template, this.templateEncoding);
        for (Map.Entry<Integer, String> token : orderedTokens.entrySet()) {
            String tokenString = token.getValue();
            int pos = sbb.indexOf(tokenString);
            assert (pos != -1) : tokenString;
            sbb.delete(pos, pos + tokenString.length());
            this.addSubStream(pos, tokens.get(tokenString));
        }
        this.templateBytes = sbb.getBytes();
    }

    private void addSubStream(int pos, InputStream stream) {
        Object existingMapValue = this.subStreams.get(pos);
        if (existingMapValue == null) {
            this.subStreams.put(pos, stream);
        } else if (existingMapValue != null && existingMapValue instanceof InputStream) {
            ArrayList<InputStream> l = new ArrayList<InputStream>();
            l.add((InputStream)existingMapValue);
            l.add(stream);
            this.subStreams.put(pos, l);
        } else if (existingMapValue != null && existingMapValue instanceof ArrayList) {
            ArrayList l = (ArrayList)existingMapValue;
            l.add(stream);
        } else {
            throw new AssertionError(existingMapValue);
        }
    }

    private InputStream getCurrentSubStream() {
        Object o = this.currentSubStreamEntry.getValue();
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof ArrayList) {
            return (InputStream)((ArrayList)o).get(this.currentSubStreamArrayIndex);
        }
        throw new AssertionError((Object)o.getClass().getName());
    }

    private boolean isEndOfStream() {
        return this.templatePos >= this.templateBytes.length && this.currentSubStreamEntry == null;
    }

    private boolean isPositionInSubStream() {
        return this.currentSubStreamEntry != null && this.currentSubStreamEntry.getKey() == this.templatePos;
    }

    private void advanceSubStream() {
        Object subStreamMapEntryVal = this.currentSubStreamEntry.getValue();
        if (subStreamMapEntryVal instanceof ArrayList) {
            ArrayList l = (ArrayList)subStreamMapEntryVal;
            if (++this.currentSubStreamArrayIndex < l.size()) {
                return;
            }
            this.currentSubStreamArrayIndex = 0;
        }
        this.currentSubStreamEntry = this.subStreamItr != null && this.subStreamItr.hasNext() ? this.subStreamItr.next() : null;
    }

    class StringByteBuffer {
        private byte[] bytes;
        private String charsetName;

        public StringByteBuffer(String s, String charsetName) throws UnsupportedEncodingException {
            this.bytes = s.getBytes(charsetName);
            this.charsetName = charsetName;
        }

        public int indexOf(String s) {
            byte[] sbytes;
            try {
                sbytes = s.getBytes(this.charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)ex);
            }
            for (int i = 0; i <= this.bytes.length - sbytes.length; ++i) {
                if (!this.subArrayEquals(i, sbytes)) continue;
                return i;
            }
            return -1;
        }

        public void delete(int start, int end) {
            int i;
            byte[] newBytes = new byte[this.bytes.length - (end - start)];
            for (i = 0; i < start; ++i) {
                newBytes[i] = this.bytes[i];
            }
            i = end;
            int j = start;
            while (i < this.bytes.length) {
                newBytes[j] = this.bytes[i];
                ++i;
                ++j;
            }
            this.bytes = newBytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        private boolean subArrayEquals(int startPos, byte[] ba) {
            int i = startPos;
            for (int j = 0; i < this.bytes.length && j < ba.length; ++i, ++j) {
                if (this.bytes[i] == ba[j]) continue;
                return false;
            }
            return true;
        }
    }

    class TokenPositionComparator
    implements Comparator<Integer> {
        TokenPositionComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1 - o2;
        }
    }
}

