/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.streaming;

import java.io.IOException;
import java.io.InputStream;

public class XmlDeclarationStrippingInputStream
extends InputStream {
    private InputStream inputStream;
    private boolean firstOpeningBracketFound;
    private Integer lastByte;

    public XmlDeclarationStrippingInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.lastByte != null) {
            b = this.lastByte;
            this.lastByte = null;
        } else {
            b = this.inputStream.read();
            if (!this.firstOpeningBracketFound && (char)b == '<') {
                this.firstOpeningBracketFound = true;
                b = this.inputStream.read();
                if ((char)b == '?') {
                    while ((char)(b = this.inputStream.read()) != '<' && b != -1) {
                    }
                } else {
                    this.lastByte = b;
                    b = 60;
                }
            }
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

