/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.streaming.buffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;
import uk.gov.hmrc.chris.utils.streaming.buffer.StreamBuffer;

public class FileStreamBuffer
extends StreamBuffer {
    protected String tempDir = null;
    private File tempFile = null;
    protected String tempFileName = null;

    public FileStreamBuffer() {
    }

    public FileStreamBuffer(String tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    protected InputStream getReadBuffer() throws StreamingException {
        try {
            return new FileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            throw new StreamingException("File Not Found - " + e.getMessage());
        }
    }

    @Override
    protected OutputStream getWriteBuffer() throws StreamingException {
        FileOutputStream buffer = null;
        try {
            this.tempFile = this.tempDir != null ? File.createTempFile("christemp", ".xml", new File(this.tempDir)) : File.createTempFile("christemp", ".xml");
            buffer = new FileOutputStream(this.tempFile);
            this.tempFileName = this.tempFile.getName();
        }
        catch (IOException e) {
            this.tempFileName = this.tempFile.getName();
            throw new StreamingException("Error creating temporary file - " + e.getMessage());
        }
        return buffer;
    }

    @Override
    public String getTempFileName() throws Exception {
        if (this.tempFileName == null || this.tempFileName.equals("")) {
            throw new Exception("Could not retrieve the file name because the value of temp file is [ " + this.tempFileName + "]");
        }
        return this.tempFileName;
    }
}

