/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.transaction;

import uk.gov.hmrc.chris.SystemException;
import uk.gov.hmrc.chris.utils.KeyGenerator;
import uk.gov.hmrc.chris.utils.ThreadLocalProxy;
import uk.gov.hmrc.chris.utils.transaction.JTATransactionManager;
import uk.gov.hmrc.chris.utils.transaction.TransactionException;
import uk.gov.hmrc.chris.utils.transaction._TransactionManager;

public final class JTATransactionCoordinator {
    private _TransactionManager manager = new JTATransactionManager(true);
    private boolean transactionStarted = false;
    private String key = null;
    private static final String MY_THREAD_LOCAL_KEY = "TRANSACTION_CORDINATOR";

    private JTATransactionCoordinator() {
    }

    public static void notifyTransactionRequired() {
        JTATransactionCoordinator instance = JTATransactionCoordinator.getInstance();
        if (instance != null) {
            instance._notifyTransactionRequired();
        }
    }

    private void _notifyTransactionRequired() {
        try {
            if (!this.transactionStarted) {
                String key = KeyGenerator.getKey();
                this.manager.start(key);
                this.transactionStarted = true;
            }
        }
        catch (TransactionException e) {
            throw new TransactionCoordinationException("Exception initialising JTA Transaction.", e);
        }
    }

    public static String obtainLock() {
        Object object = ThreadLocalProxy.getThreadLocalObject(MY_THREAD_LOCAL_KEY);
        if (object == null) {
            String key;
            JTATransactionCoordinator cordinator = new JTATransactionCoordinator();
            cordinator.key = key = KeyGenerator.getKey();
            ThreadLocalProxy.setThreadLocalObject(MY_THREAD_LOCAL_KEY, cordinator);
            return key;
        }
        throw new LockedException("A lock is already obatained on the cordinator");
    }

    private static JTATransactionCoordinator getInstance() {
        Object object = ThreadLocalProxy.getThreadLocalObject(MY_THREAD_LOCAL_KEY);
        return (JTATransactionCoordinator)object;
    }

    private void clearInstance() {
        Object object = ThreadLocalProxy.getThreadLocalObject(MY_THREAD_LOCAL_KEY);
        if (object != null) {
            this.key = null;
            this.transactionStarted = false;
            ThreadLocalProxy.setThreadLocalObject(MY_THREAD_LOCAL_KEY, null);
        }
    }

    public static void commit(String lockKey) throws TransactionCoordinationException {
        JTATransactionCoordinator instance = JTATransactionCoordinator.getInstance();
        if (instance == null) {
            String msg = "Transaction co-ordinator must be initialised prior to commit";
            throw new TransactionCoordinationException(msg);
        }
        instance._commit(lockKey);
    }

    private void _commit(String lockKey) throws TransactionCoordinationException {
        this.unlock(lockKey);
        try {
            this.manager.commit();
        }
        catch (TransactionException e) {
            throw new TransactionCoordinationException("Exception occured while trying to commit the transaction", e);
        }
        finally {
            this.clearInstance();
        }
    }

    public static void commitRequired(String lockKey) throws TransactionCoordinationException {
        JTATransactionCoordinator instance = JTATransactionCoordinator.getInstance();
        if (instance == null) {
            String msg = "Transaction co-ordinator must be initialised prior to commit required";
            throw new TransactionCoordinationException(msg);
        }
        instance._commitRequired(lockKey);
    }

    private void _commitRequired(String lockKey) throws TransactionCoordinationException {
        block6: {
            try {
                this.unlock(lockKey);
                if (this.transactionStarted) {
                    this.manager.commit();
                    break block6;
                }
                throw new NoActiveTransaction("Commit called but there was no transaction");
            }
            catch (TransactionException e) {
                throw new TransactionCoordinationException("Exception occured while trying to commit the transaction", e);
            }
            finally {
                this.clearInstance();
            }
        }
    }

    public static void rollback(String lockKey) throws TransactionCoordinationException {
        JTATransactionCoordinator instance = JTATransactionCoordinator.getInstance();
        if (instance == null) {
            String msg = "Transaction co-ordinator must be initialised prior to rollback";
            throw new TransactionCoordinationException(msg);
        }
        instance._rollback(lockKey);
    }

    private void _rollback(String lockKey) throws TransactionCoordinationException {
        this.unlock(lockKey);
        try {
            if (this.transactionStarted) {
                this.manager.rollback();
            }
        }
        catch (TransactionException e) {
            throw new TransactionCoordinationException("Exception occured while trying to commit the transaction", e);
        }
        finally {
            this.clearInstance();
        }
    }

    private void unlock(String lockKey) {
        if (!lockKey.equalsIgnoreCase(this.key)) {
            throw new LockedException("You are trying the wrong key, only the holder ofthe key can call commit");
        }
    }

    public static class LockedException
    extends SystemException {
        private static final long serialVersionUID = 1L;

        public LockedException(String message) {
            super(message);
        }
    }

    public class NoActiveTransaction
    extends SystemException {
        private static final long serialVersionUID = 1L;

        public NoActiveTransaction(String message) {
            super(message);
        }
    }

    public static class TransactionCoordinationException
    extends SystemException {
        private static final long serialVersionUID = 1L;

        public TransactionCoordinationException(String message) {
            super(message);
        }

        public TransactionCoordinationException(String message, Throwable exception) {
            super(message, exception);
        }
    }
}

