/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.transaction;

import javax.naming.Context;
import javax.naming.NamingException;
import uk.gov.hmrc.chris.ChRISBaseLogger;
import uk.gov.hmrc.chris.utils.JNDIUsage.JNDIUsage;
import uk.gov.hmrc.chris.utils.transaction.TransactionException;
import uk.gov.hmrc.chris.utils.transaction._TransactionManager;
import weblogic.transaction.UserTransaction;

public class JTATransactionManager
implements _TransactionManager {
    UserTransaction transaction = null;
    private boolean isTransactionActive = false;
    private boolean hasInited = false;

    public JTATransactionManager() throws TransactionException {
        this.init();
    }

    public JTATransactionManager(boolean lazy) {
    }

    @Override
    public void commit() throws TransactionException {
        if (this.isTransactionActive) {
            try {
                this.transaction.commit();
                this.isTransactionActive = false;
            }
            catch (Exception e) {
                throw new TransactionException("Exception occurred while committing transaction", e);
            }
        } else {
            throw new TransactionException("Commit called but no transaction active");
        }
    }

    @Override
    public void rollback() throws TransactionException {
        if (this.isTransactionActive) {
            try {
                this.transaction.rollback();
                this.isTransactionActive = false;
            }
            catch (Exception e) {
                throw new TransactionException("could roll back the transaction", e);
            }
        } else {
            throw new TransactionException("Roll back called, but no transaction active");
        }
    }

    @Override
    public void start(String name) throws TransactionException {
        this.init();
        if (!this.isTransactionActive) {
            try {
                this.transaction.begin(name);
                this.isTransactionActive = true;
            }
            catch (Exception e) {
                throw new TransactionException("Error in starting transaction", e);
            }
        } else {
            throw new TransactionException("Start called but already a transaction in progress");
        }
    }

    @Override
    public void rollbackAndIgnore() {
        try {
            this.rollback();
        }
        catch (Exception e) {
            ChRISBaseLogger.warning("could not roll back the transaction :" + e.getMessage());
        }
        this.isTransactionActive = false;
    }

    protected void init() throws TransactionException {
        if (!this.hasInited) {
            Context context = JNDIUsage.getInstance().getInitialContext(null);
            try {
                this.transaction = (UserTransaction)context.lookup("java:comp/UserTransaction");
                this.hasInited = true;
            }
            catch (NamingException e) {
                throw new TransactionException("Exception occurred while initialising transaction", e);
            }
        }
    }
}

