/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.trigger;

import java.io.File;
import java.util.logging.LogManager;
import org.apache.commons.lang.StringUtils;
import uk.gov.hmrc.chris.utils.logging.ChrisLogFactory;
import uk.gov.hmrc.chris.utils.trigger.ITrigger;
import uk.gov.hmrc.chris.utils.trigger.PolledPeriodicTrigger;
import uk.gov.hmrc.chris.utils.trigger.PropertyFileTrigger;

public class ChrisLoggingPropertyFileMonitor {
    private static final ChrisLoggingPropertyFileMonitor INSTANCE = new ChrisLoggingPropertyFileMonitor();
    private PolledPeriodicTrigger periodicTrigger;
    private ITrigger loggingFileChangedTrigger;

    private ChrisLoggingPropertyFileMonitor() {
        String loggingConfigLocation = System.getProperty("java.util.logging.config.file");
        if (StringUtils.isBlank((String)loggingConfigLocation)) {
            throw new IllegalStateException("Logging config not supplied a -Djava.util.logging.config.file");
        }
        File loggingConfigFile = new File(loggingConfigLocation);
        if (!loggingConfigFile.exists()) {
            throw new IllegalStateException("Couldn't find logging config not supplied a -Djava.util.logging.config.file as " + loggingConfigLocation);
        }
        this.periodicTrigger = new PolledPeriodicTrigger();
        this.periodicTrigger.setTriggerPeriodInMinutes(1L);
        this.loggingFileChangedTrigger = new PropertyFileTrigger(loggingConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndReloadIfNecessary() {
        PolledPeriodicTrigger polledPeriodicTrigger = ChrisLoggingPropertyFileMonitor.INSTANCE.periodicTrigger;
        synchronized (polledPeriodicTrigger) {
            if (ChrisLoggingPropertyFileMonitor.INSTANCE.periodicTrigger.fired() && ChrisLoggingPropertyFileMonitor.INSTANCE.loggingFileChangedTrigger.fired()) {
                ChrisLogFactory.getLog().warn("Logging file change detected - updating logging configuration.");
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to update logging config", e);
                }
            }
        }
    }
}

