/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.trigger;

import uk.gov.hmrc.chris.utils.trigger.ITrigger;

public class PolledPeriodicTrigger
implements ITrigger {
    private long lastTrigger;
    private long triggerPeriod;

    public PolledPeriodicTrigger() {
        this.lastTrigger = System.currentTimeMillis();
    }

    PolledPeriodicTrigger(long lastTrigger) {
        this.lastTrigger = lastTrigger;
    }

    long getTriggerPeriod() {
        return this.triggerPeriod;
    }

    public void setTriggerPeriodInMinutes(long minutes) {
        this.triggerPeriod = minutes * 60L * 1000L;
    }

    public void setTriggerPeriodInHours(long hours) {
        this.triggerPeriod = hours * 60L * 60L * 1000L;
    }

    @Override
    public boolean fired() {
        long now = System.currentTimeMillis();
        if (now < this.lastTrigger + this.triggerPeriod) {
            return false;
        }
        this.lastTrigger = now;
        return true;
    }
}

