/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.trigger;

import java.io.File;
import uk.gov.hmrc.chris.utils.trigger.ITrigger;

public class PropertyFileTrigger
implements ITrigger {
    private long lastUpdatedTimestamp;
    private final File file;

    public PropertyFileTrigger(File file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("File was null");
        }
        this.file = file;
        this.lastUpdatedTimestamp = file.lastModified();
    }

    @Override
    public boolean fired() {
        long timeStamp = this.file.lastModified();
        if (this.lastUpdatedTimestamp != timeStamp) {
            this.lastUpdatedTimestamp = timeStamp;
            return true;
        }
        return false;
    }
}

