/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.xml;

import java.io.IOException;
import java.io.OutputStream;
import uk.gov.hmrc.chris.observe.Informable;
import uk.gov.hmrc.chris.utils.xml.ManagedStandardXMLOutputStream;
import uk.gov.hmrc.chris.utils.xml.XMLProcessingException;
import uk.gov.hmrc.chris.utils.xml.XMLRootElement;

public class ManagedChunkingXMLOutputStream
extends ManagedStandardXMLOutputStream {
    protected int chunkingSize = 0;
    protected int currentCount = 0;
    protected int accumulatedCount = 0;
    protected int maxSize = -1;
    protected boolean chunked = false;
    boolean maxSizeReached = false;
    protected Informable manager;

    public ManagedChunkingXMLOutputStream(int chunkingSize, OutputStream destination, Informable manager, byte[] metaInformation, XMLRootElement xmlRoot) throws XMLProcessingException {
        this(chunkingSize, -1, destination, manager, metaInformation, xmlRoot);
    }

    public ManagedChunkingXMLOutputStream(int chunkingSize, int maxSize, OutputStream destination, Informable manager, byte[] metaInformation, XMLRootElement xmlRoot) throws XMLProcessingException {
        super(destination, metaInformation, xmlRoot);
        this.chunkingSize = chunkingSize;
        this.manager = manager;
        this.maxSize = maxSize;
    }

    @Override
    public void addOneToCount() throws XMLProcessingException {
        ++this.currentCount;
        ++this.accumulatedCount;
        this.checkAndChunk();
    }

    private void checkAndChunk() {
        this.chunked = this.chunkingSize > 0 && this.currentCount > this.chunkingSize;
        boolean bl = this.maxSizeReached = this.maxSize > 0 && this.accumulatedCount > this.maxSize;
        if (this.maxSizeReached) {
            this.chunked = true;
        }
        if (this.chunked) {
            this.destination = (OutputStream)this.manager.inform();
            this.currentCount = 1;
            this.chunked = false;
            if (this.maxSizeReached) {
                this.accumulatedCount = 1;
                this.maxSizeReached = false;
            }
            try {
                this.startNewDocument();
            }
            catch (Exception e) {
                new XMLProcessingException("Exception initialising the stream", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.writeEndInformation();
    }

    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public int getCurrentCount() {
        return this.currentCount;
    }

    public int getAccumulatedCount() {
        return this.accumulatedCount;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getChunkingSize() {
        return this.chunkingSize;
    }
}

