/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import uk.gov.hmrc.chris.UnImplementedOperationException;
import uk.gov.hmrc.chris.utils.xml.ManagedXMLOutputStream;
import uk.gov.hmrc.chris.utils.xml.XMLProcessingException;
import uk.gov.hmrc.chris.utils.xml.XMLRootElement;

public class ManagedStandardXMLOutputStream
extends ManagedXMLOutputStream {
    protected OutputStream destination;
    protected byte[] metaInformation;
    protected boolean isWriting;
    private XMLRootElement element;

    public ManagedStandardXMLOutputStream(OutputStream destination, byte[] metaInformation, XMLRootElement xmlRoot) {
        this.destination = destination;
        this.metaInformation = metaInformation;
        this.element = xmlRoot;
        try {
            this.startNewDocument();
        }
        catch (Exception e) {
            new XMLProcessingException("Exception initialising the stream", e);
        }
    }

    @Override
    public void addOneToCount() throws XMLProcessingException {
    }

    @Override
    public void write(byte[] arg0) throws IOException {
        this.destination.write(arg0);
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        this.destination.write(arg0, arg1, arg2);
    }

    @Override
    public void write(int arg0) throws IOException {
        this.destination.write(arg0);
    }

    protected void writeStartInformation() throws Exception {
        byte[] encodingBytes = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes(), "UTF-8").getBytes();
        this.destination.write(encodingBytes);
        String rootName = this.element.getRootName();
        if (rootName != null) {
            this.destination.write("<".getBytes());
            this.destination.write(rootName.getBytes());
            this.writeAttributes(this.element.getRootAttributes());
            this.destination.write(">".getBytes());
        }
        if (this.metaInformation != null) {
            this.destination.write(this.metaInformation);
        }
    }

    protected void writeEndInformation() throws IOException {
        String startTag = null;
        if (this.element != null) {
            startTag = this.element.getRootName();
        }
        if (startTag != null) {
            this.destination.write("</".getBytes());
            this.destination.write(startTag.getBytes());
            this.destination.write(">".getBytes());
        }
        this.isWriting = false;
    }

    protected void startNewDocument() throws Exception {
        this.writeStartInformation();
        this.isWriting = true;
    }

    @Override
    public void close() throws IOException {
        if (this.isWriting) {
            this.writeEndInformation();
            this.destination.close();
        }
    }

    protected void writeAttributes(Map<String, String> attrbs) throws IOException {
        for (String key : attrbs.keySet()) {
            this.destination.write(" ".getBytes());
            this.destination.write(key.getBytes());
            this.destination.write("=".getBytes());
            this.destination.write("\"".getBytes());
            this.destination.write(attrbs.get(key).getBytes());
            this.destination.write("\"".getBytes());
        }
    }

    @Override
    public int getCurrentCount() {
        throw new UnImplementedOperationException("This does not implement the method, please override");
    }
}

