/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.hmrc.chris.utils.DateUtils;
import uk.gov.hmrc.chris.utils.streaming.StreamHandler;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilderByteArrayOutputStream;

public class XMLBuilder {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String XSD_TIMESTAMP = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String XSD_DATE = "yyyy-MM-dd";
    private static final String XSD_TIME = "HH:mm:ss";
    private XMLBuilderByteArrayOutputStream baos = null;
    private XMLStreamWriter writer = null;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private boolean documentClosed = false;
    private static XMLOutputFactory factory = XMLOutputFactory.newInstance();
    private OutputStream os = null;
    private boolean documentStarted = false;
    private boolean overrideEndDocument = false;

    public XMLBuilder(Boolean encoding) throws XMLBuilderException {
        try {
            this.baos = new XMLBuilderByteArrayOutputStream();
            this.writer = factory.createXMLStreamWriter(this.baos, UTF8_ENCODING);
            if (encoding.booleanValue()) {
                this.writer.writeStartDocument(UTF8_ENCODING, "1.0");
                this.documentStarted = true;
            }
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Problem in constructor", e);
        }
    }

    public XMLBuilder(Boolean encoding, OutputStream os) throws XMLBuilderException {
        this.os = os;
        try {
            this.writer = factory.createXMLStreamWriter(os, UTF8_ENCODING);
            if (encoding.booleanValue()) {
                this.writer.writeStartDocument(UTF8_ENCODING, "1.0");
                this.documentStarted = true;
            }
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Problem in constructor", e);
        }
    }

    public XMLBuilder(Boolean encoding, Writer os) throws XMLStreamException, FactoryConfigurationError {
        this.writer = factory.createXMLStreamWriter(os);
        if (encoding.booleanValue()) {
            this.writer.writeStartDocument(UTF8_ENCODING, "1.0");
            this.documentStarted = true;
        }
    }

    public void setOverrideEndDocument(boolean overrideEndDocument) {
        this.overrideEndDocument = overrideEndDocument;
    }

    public int getBufferSize() {
        return this.baos.size();
    }

    public int getFillsSize() {
        return this.baos.getFillSize();
    }

    public XMLBuilder() throws XMLBuilderException {
        this(true);
    }

    public void writeStartElement(String name) throws XMLBuilderException {
        try {
            this.writer.writeStartElement(name);
            this.documentStarted = true;
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write start node " + name, e);
        }
    }

    public void writeEndElement() throws XMLBuilderException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write end node", e);
        }
    }

    public void writeCData(String data) throws XMLBuilderException {
        try {
            this.writer.writeCData(data);
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write CData", e);
        }
    }

    public void writeEmptyElement(String name) throws XMLBuilderException {
        try {
            this.writer.writeEmptyElement(name);
            this.documentStarted = true;
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write empty element", e);
        }
    }

    public void endDocument() throws XMLBuilderException {
        if (!this.documentClosed && !this.overrideEndDocument) {
            try {
                if (this.documentStarted) {
                    this.writer.writeEndDocument();
                }
                this.writer.flush();
                if (this.baos != null) {
                    this.writer.close();
                }
                this.documentClosed = true;
            }
            catch (XMLStreamException e) {
                throw new XMLBuilderException("Unable to end document", e);
            }
        }
    }

    public void writeAttribute(String name, String value) throws XMLBuilderException {
        try {
            this.writer.writeAttribute(name, value);
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unbale to write attribute " + name + " " + value, e);
        }
    }

    public void writeSimpleElementIfNotEmpty(String elementName, String elementValue) throws XMLBuilderException {
        if (elementValue != null && !elementValue.equals("")) {
            this.writeSimpleElement(elementName, elementValue);
        }
    }

    public void writeSimpleElement(String elementName, String elementValue) throws XMLBuilderException {
        if (elementValue != null) {
            this.writeStartElement(elementName);
            this.writeText(elementValue);
            this.writeEndElement();
        }
    }

    public void writeSimpleElement(String elementName, String ... elementValues) throws XMLBuilderException {
        if (elementValues != null) {
            for (int x = 0; x < elementValues.length; ++x) {
                this.writeStartElement(elementName);
                this.writeText(elementValues[x]);
                this.writeEndElement();
            }
        }
    }

    public void writeSimpleElement(String elementName, Boolean elementValue) throws XMLBuilderException {
        this.writeStartElement(elementName);
        this.writeText(String.valueOf(elementValue));
        this.writeEndElement();
    }

    public void writeSimpleElement(String elementName, Long elementValue) throws XMLBuilderException {
        this.writeStartElement(elementName);
        this.writeText(String.valueOf(elementValue));
        this.writeEndElement();
    }

    public void writeSimpleTimeStampElement(String nodeName, Date nodeValue) throws XMLBuilderException {
        if (nodeValue != null) {
            this.writeStartElement(nodeName);
            try {
                this.writeText(DateUtils.formatDate(XSD_TIMESTAMP, nodeValue));
            }
            catch (DateUtils.DateUtilsException e) {
                throw new XMLBuilderException("Could not format date", e);
            }
            this.writeEndElement();
        }
    }

    public void writeSimpleTimeElement(String nodeName, Date nodeValue) throws XMLBuilderException {
        if (nodeValue != null) {
            this.writeStartElement(nodeName);
            try {
                this.writeText(DateUtils.formatDate(XSD_TIME, nodeValue));
            }
            catch (DateUtils.DateUtilsException e) {
                throw new XMLBuilderException("Could not format date into time", e);
            }
            this.writeEndElement();
        }
    }

    public void writeSimpleDateElement(String nodeName, Date nodeValue) throws XMLBuilderException {
        if (nodeValue != null) {
            this.writeStartElement(nodeName);
            try {
                this.writeText(DateUtils.formatDate(XSD_DATE, nodeValue));
            }
            catch (DateUtils.DateUtilsException e) {
                throw new XMLBuilderException("Could not format date", e);
            }
            this.writeEndElement();
        }
    }

    public void writeSimpleElement(String nodeName, Double nodeValue) throws XMLBuilderException {
        this.writeStartElement(nodeName);
        this.writeText(String.valueOf(nodeValue));
        this.writeEndElement();
    }

    public void writeSimpleElement(String nodeName, int nodeValue) throws XMLBuilderException {
        this.writeStartElement(nodeName);
        this.writeText(String.valueOf(nodeValue));
        this.writeEndElement();
    }

    public void writeSimpleElement(String nodeName, Integer nodeValue) throws XMLBuilderException {
        if (nodeValue != null) {
            this.writeStartElement(nodeName);
            this.writeText(String.valueOf(nodeValue));
            this.writeEndElement();
        }
    }

    public void writeSimpleElement(String nodeName, ArrayList<String> nodeValues) throws XMLBuilderException {
        if (nodeValues != null) {
            for (int x = 0; x < nodeValues.size(); ++x) {
                this.writeStartElement(nodeName);
                this.writeText(nodeValues.get(x));
                this.writeEndElement();
            }
        }
    }

    public void addAttribute(XMLBuilder builder, String attName, String attValue) throws XMLBuilderException {
        if (attValue != null) {
            builder.writeAttribute(attName, attValue);
        }
    }

    public void writeText(String text) throws XMLBuilderException {
        String data = "";
        if (text != null) {
            data = text;
        }
        try {
            this.writer.writeCharacters(data);
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write text", e);
        }
    }

    public void newLine() throws XMLBuilderException {
        try {
            this.writer.writeCharacters(NEW_LINE);
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write text", e);
        }
    }

    public void writeChars(char[] chars, int offset, int len) throws XMLBuilderException {
        try {
            this.writer.writeCharacters(chars, offset, len);
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write text", e);
        }
    }

    public void flush() throws XMLBuilderException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Problem flushing stream", e);
        }
    }

    public byte[] getBytes() throws XMLBuilderException {
        if (this.baos == null) {
            throw new XMLBuilderException("Stream unavailable", null);
        }
        this.endDocument();
        return this.baos.toByteArray();
    }

    public byte[] getBytesAsNewData() throws XMLBuilderException {
        if (this.baos == null) {
            throw new XMLBuilderException("Stream unavailable", null);
        }
        this.endDocument();
        return this.baos.toNewByteArray();
    }

    public void appendStream(InputStream xmlStream) throws XMLBuilderException {
        OutputStream streamToAppend = null;
        if (this.os == null && this.baos == null) {
            throw new XMLBuilderException("Unable to append to stream - outputstream is null", null);
        }
        if (this.writer != null) {
            this.writeText("");
            this.flush();
        }
        streamToAppend = this.os != null ? this.os : this.baos;
        try {
            StreamHandler.streamData(xmlStream, streamToAppend);
        }
        catch (StreamingException e) {
            throw new XMLBuilderException("Unable to append to stream - exception while streaming", e);
        }
    }

    public void AppendDocument(InputStream is) throws XMLBuilderException {
        new AppendDocument(is, this);
    }

    public void AppendDocument(Reader r) throws XMLBuilderException {
        new AppendDocument(r, this);
    }

    public void writeComment(String arg0) throws XMLBuilderException {
        try {
            this.writer.writeComment(arg0);
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write Comment", e);
        }
    }

    public void writeComment(char[] arg0, int start, int length) throws XMLBuilderException {
        try {
            this.writer.writeComment(new String(arg0, start, length));
        }
        catch (XMLStreamException e) {
            throw new XMLBuilderException("Unable to write Comment", e);
        }
    }

    public String toString() {
        try {
            return new String(this.getBytes(), 0, this.getBufferSize(), UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding problems when converting bytes int Java String", e);
        }
        catch (XMLBuilderException e) {
            throw new RuntimeException("Problem when inspecting byte stream", e);
        }
    }

    public InputStream toInputSTream() {
        try {
            return new ByteArrayInputStream(this.getBytes(), 0, this.getFillsSize());
        }
        catch (XMLBuilderException e) {
            throw new RuntimeException("Problem when inspecting byte stream", e);
        }
    }

    static {
        if (factory.isPropertySupported("com.ctc.wstx.outputValidateStructure")) {
            factory.setProperty("com.ctc.wstx.outputValidateStructure", false);
        }
    }

    private class AppendDocument
    extends DefaultHandler {
        XMLBuilder xml = null;

        public AppendDocument(InputStream documentToAppend, XMLBuilder xml) throws XMLBuilderException {
            this.xml = xml;
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(documentToAppend, (DefaultHandler)this);
            }
            catch (Exception e) {
                throw new XMLBuilderException("Unable to append the document to the current builder stream", e);
            }
        }

        public AppendDocument(Reader documentToAppend, XMLBuilder xml) throws XMLBuilderException {
            this.xml = xml;
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(new InputSource(documentToAppend), (DefaultHandler)this);
            }
            catch (Exception e) {
                throw new XMLBuilderException("Unable to append the document to the current builder stream", e);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                this.xml.writeStartElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.xml.writeAttribute(attributes.getQName(i), attributes.getValue(i));
                }
            }
            catch (XMLBuilderException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                this.xml.writeEndElement();
            }
            catch (XMLBuilderException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.xml.writeChars(ch, start, length);
            }
            catch (XMLBuilderException e) {
                throw new SAXException(e);
            }
        }
    }

    public class XMLBuilderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XMLBuilderException(String message, Throwable exception) {
            super(message, exception);
        }
    }
}

