/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.xml;

import java.io.ByteArrayOutputStream;

public class XMLBuilderByteArrayOutputStream
extends ByteArrayOutputStream {
    private boolean invalid = false;

    public XMLBuilderByteArrayOutputStream() {
        super(4096);
    }

    public XMLBuilderByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    private void checkValidity() {
        if (this.invalid) {
            throw new RuntimeException("You have tried to use an invalid XMLBuilderByteArrayOutputStream");
        }
    }

    @Override
    public synchronized byte[] toByteArray() {
        this.invalid = true;
        return this.buf;
    }

    public synchronized int getFillSize() {
        return this.count;
    }

    public synchronized byte[] toNewByteArray() {
        return super.toByteArray();
    }

    @Override
    public synchronized void write(int b) {
        this.checkValidity();
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max((int)((double)this.buf.length * 1.5), newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.checkValidity();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max((int)((double)this.buf.length * 0.5), newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }
}

