/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.xml;

import java.io.IOException;
import java.io.InputStream;

public class XmlCDataFilteringInputStream
extends InputStream {
    protected volatile InputStream in;
    private static final int[] CDATA_START = new int[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    private static final int[] CDATA_END = new int[]{93, 93, 62};
    private int[] buf = new int[CDATA_START.length];
    private State state;

    public XmlCDataFilteringInputStream(InputStream in) {
        this.in = in;
        this.state = State.INITAL;
    }

    @Override
    public int read() throws IOException {
        if (this.state == State.INITAL) {
            this.fill(this.buf.length);
            this.state = State.LOOKING_FOR_START;
        }
        if (this.state == State.LOOKING_FOR_START && this.matches(this.buf, CDATA_START)) {
            this.shift(CDATA_START.length);
            this.state = State.LOOKING_FOR_END;
        }
        if (this.state == State.LOOKING_FOR_END && this.matches(this.buf, CDATA_END)) {
            this.shift(CDATA_END.length);
            this.state = State.FINISHED;
        }
        int b = this.buf[0];
        this.shift(1);
        return b;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private void fill(int count) throws IOException {
        for (int i = this.buf.length - count; i < this.buf.length; ++i) {
            this.buf[i] = this.in.read();
        }
    }

    private void shift(int count) throws IOException {
        for (int i = count; i < this.buf.length; ++i) {
            this.buf[i - count] = this.buf[i];
        }
        this.fill(count);
    }

    private boolean matches(int[] a, int[] b) {
        for (int n = 0; n < a.length && n < b.length; ++n) {
            if (a[n] == b[n]) continue;
            return false;
        }
        return true;
    }

    private static enum State {
        INITAL,
        LOOKING_FOR_START,
        LOOKING_FOR_END,
        FINISHED;

    }
}

