/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class XmlDeclarationFilteringInputStream
extends FilterInputStream {
    private static final int WHITESPACE = 32;
    private State state;
    private State stateAfterBuffer;
    private int[] buf = new int[4];
    private int readAhead = 0;

    public XmlDeclarationFilteringInputStream(InputStream in) {
        super(in);
        this.state = State.START_OF_FILE;
    }

    @Override
    public int read() throws IOException {
        switch (this.state) {
            case START_OF_FILE: {
                int b = this.in.read();
                if (b == -1 || b != 60) {
                    this.state = State.POST_FILTER;
                    return b;
                }
                assert (b == 60);
                this.buf[0] = this.in.read();
                ++this.readAhead;
                if (this.buf[0] == -1) {
                    this.state = State.STREAM_BUFFER;
                    return b;
                }
                this.buf[1] = this.in.read();
                ++this.readAhead;
                if (this.buf[1] == -1) {
                    this.state = State.STREAM_BUFFER;
                    return b;
                }
                this.buf[2] = this.in.read();
                ++this.readAhead;
                if (this.buf[2] == -1) {
                    this.state = State.STREAM_BUFFER;
                    return b;
                }
                this.buf[3] = this.in.read();
                ++this.readAhead;
                if (this.buf[3] == -1) {
                    this.state = State.STREAM_BUFFER;
                    return b;
                }
                this.state = State.STREAM_BUFFER;
                if (!(this.buf[0] != 63 || this.buf[1] != 120 && this.buf[1] != 88 || this.buf[2] != 109 && this.buf[2] != 77 || this.buf[3] != 108 && this.buf[3] != 76)) {
                    Arrays.fill(this.buf, 32);
                    this.stateAfterBuffer = State.FILTERING_XML_DEC;
                    return 32;
                }
                this.stateAfterBuffer = State.POST_FILTER;
                return b;
            }
            case STREAM_BUFFER: {
                assert (this.readAhead > 0);
                int b = this.buf[this.buf.length - this.readAhead--];
                if (this.readAhead == 0) {
                    assert (this.stateAfterBuffer != null);
                    this.state = this.stateAfterBuffer;
                }
                return b;
            }
            case FILTERING_XML_DEC: {
                assert (this.readAhead == 0);
                int b = this.in.read();
                if (b == -1) {
                    return -1;
                }
                if (b == 63) {
                    int b1 = this.in.read();
                    ++this.readAhead;
                    if (b1 == -1) {
                        this.state = State.POST_FILTER;
                    } else if (b1 == 62) {
                        this.buf[0] = 32;
                        this.state = State.STREAM_BUFFER;
                        this.stateAfterBuffer = State.POST_FILTER;
                    }
                }
                return 32;
            }
            case POST_FILTER: {
                return this.in.read();
            }
        }
        throw new AssertionError();
    }

    @Override
    public int read(byte[] ba) throws IOException {
        return this.read(ba, 0, ba.length);
    }

    @Override
    public int read(byte[] ba, int off, int len) throws IOException {
        if (this.state == State.POST_FILTER) {
            return this.in.read(ba, off, len);
        }
        int read = 0;
        for (int i = 0; i < len; ++i) {
            int b = this.read();
            if (b == -1) {
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            ++read;
            ba[off + i] = (byte)(b & 0xFF);
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() + this.readAhead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesRead;
        if (this.state == State.POST_FILTER) {
            return this.in.skip(n);
        }
        for (bytesRead = 0L; bytesRead < n; ++bytesRead) {
            if (this.state != State.POST_FILTER && bytesRead < n) {
                return this.in.skip(n - bytesRead) + bytesRead;
            }
            int b = this.read();
            if (b != -1) continue;
            return bytesRead;
        }
        return bytesRead;
    }

    @Override
    public synchronized void mark(int readLimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark/reset not supported. Clients should call markSupported before calling this method to check if this method is implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private static enum State {
        START_OF_FILE,
        STREAM_BUFFER,
        FILTERING_XML_DEC,
        POST_FILTER;

    }
}

