/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.common.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class NonPersistentProperties
extends Properties {
    private static final long serialVersionUID = 4112578634029874840L;
    private final Hashtable<String, String> transientProperties = new Hashtable(5);

    public NonPersistentProperties() {
    }

    public NonPersistentProperties(Properties defaults) {
        super(defaults);
    }

    public synchronized boolean setNonPersistentProperty(String key) {
        boolean operationSuccessful = false;
        if (this.containsKey(key)) {
            String value = this.getProperty(key);
            if (!this.transientProperties.containsKey(key)) {
                this.transientProperties.put(key, value);
            }
            operationSuccessful = true;
        }
        return operationSuccessful;
    }

    public synchronized Object setNonPersistentProperty(String key, String value) {
        Object previousValue = null;
        if (this.transientProperties.containsKey(key)) {
            previousValue = this.transientProperties.put(key, value);
        } else {
            previousValue = this.get(key);
            this.transientProperties.put(key, value);
        }
        return previousValue;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        this.transientProperties.remove(key);
        return super.setProperty(key, value);
    }

    @Override
    public synchronized Object get(Object key) {
        return super.get(key);
    }

    @Override
    public String getProperty(String key) {
        String property = null;
        property = this.transientProperties.containsKey(key) ? this.transientProperties.get(key) : super.getProperty(key);
        return property;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = null;
        property = this.transientProperties.containsKey(key) ? this.transientProperties.get(key) : super.getProperty(key, defaultValue);
        return property;
    }

    @Override
    public Enumeration<?> propertyNames() {
        Enumeration<?> e = super.propertyNames();
        Hashtable<String, String> h = new Hashtable<String, String>();
        while (e.hasMoreElements()) {
            String currName = (String)e.nextElement();
            h.put(currName, null);
        }
        h.putAll(this.transientProperties);
        return h.keys();
    }

    @Override
    public void list(PrintStream out) {
        super.list(out);
        out.println("-- transient properties --");
        Enumeration<String> e = this.transientProperties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = this.transientProperties.get(key);
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    @Override
    public void list(PrintWriter out) {
        super.list(out);
        out.println("-- transient properties --");
        Enumeration<String> e = this.transientProperties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = this.transientProperties.get(key);
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    public synchronized Object remove(String key) {
        String removedTransient = this.transientProperties.remove(key);
        Object removedPersistent = super.remove(key);
        return removedTransient != null ? removedTransient : removedPersistent;
    }

    public synchronized Object removeTransient(String key) {
        return this.transientProperties.remove(key);
    }
}

