/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ConfigUpdate {
    public static final String ELEMENT_RIM_ARTEFACTS_DIR = "RIMArtefactsDirectory";
    public static final String ELEMENT_SERVICE = "Service";
    public static final String ELEMENT_ENVELOPE = "Envelope";
    public static final String ATTRIBUTE_URI = "uri";

    public void updateService(File validatorConfig, File serviceConfig, File rimDir) throws Exception {
        SAXBuilder builder1 = new SAXBuilder();
        SAXBuilder builder2 = new SAXBuilder();
        Document configDoc = builder1.build(validatorConfig);
        Document serviceDoc = builder2.build(serviceConfig);
        Element serviceRoot = serviceDoc.getRootElement();
        List serviceElements = serviceRoot.getChildren(ELEMENT_SERVICE);
        Element configRoot = configDoc.getRootElement();
        Element configEnvelope = configRoot.getChild(ELEMENT_ENVELOPE);
        List configElements = configEnvelope.getChildren(ELEMENT_SERVICE);
        for (Object serviceObject : serviceElements) {
            Element serviceElement = (Element)serviceObject;
            String serviceURI = serviceElement.getAttributeValue(ATTRIBUTE_URI);
            for (Object configObject : configElements) {
                Element configElement = (Element)configObject;
                if (!configElement.getName().equals(ELEMENT_SERVICE) || !configElement.getAttribute(ATTRIBUTE_URI).getValue().equals(serviceURI)) continue;
                configEnvelope.removeContent((Content)configElement);
                break;
            }
            Element newService = (Element)serviceElement.clone();
            Element rimArtsDir = new Element(ELEMENT_RIM_ARTEFACTS_DIR);
            rimArtsDir.setText(rimDir.getPath());
            newService.addContent((Content)rimArtsDir);
            configEnvelope.addContent((Content)newService);
        }
        this.saveConfig(configDoc, validatorConfig);
    }

    public void deleteService(File validatorConfig, String uri) throws Exception {
        SAXBuilder builder1 = new SAXBuilder();
        Document valConfig = builder1.build(validatorConfig);
        Element root = valConfig.getRootElement();
        Element envelope = root.getChild(ELEMENT_ENVELOPE);
        for (Element e : envelope.getChildren()) {
            if (!e.getName().equals(ELEMENT_SERVICE) || !e.getAttribute(ATTRIBUTE_URI).getValue().equals(uri)) continue;
            envelope.removeContent((Content)e);
            break;
        }
        this.saveConfig(valConfig, validatorConfig);
    }

    private void saveConfig(Document valConfig, File validatorConfig) throws Exception {
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat());
        FileOutputStream fos = new FileOutputStream(validatorConfig);
        output.output(valConfig, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    public static String[] getServiceURIs(File serviceConfig) {
        Document docConfig;
        SAXBuilder builder = new SAXBuilder();
        try {
            docConfig = builder.build(serviceConfig);
        }
        catch (JDOMException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        Element serviceConfigElement = docConfig.getRootElement();
        List serviceElements = serviceConfigElement.getChildren();
        ArrayList<String> uris = new ArrayList<String>();
        for (Object serviceObject : serviceElements) {
            Element serviceElement = (Element)serviceObject;
            String uri = serviceElement.getAttributeValue(ATTRIBUTE_URI);
            uris.add(uri);
        }
        return uris.toArray(new String[uris.size()]);
    }
}

