/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.io.File;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.gov.hmrc.aspire.lts.updatemanager.LocalFileStoreException;

public class FileAccessor {
    private SortedSet<String> keySet = new TreeSet<String>();

    public FileAccessor(String baseDirectory) throws LocalFileStoreException {
        File baseDir = new File(baseDirectory);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            return;
        }
        String separator = System.getProperty("file.separator");
        String regEx = null;
        regEx = separator.equals("/") ? "[/]" : "[\\\\]";
        try {
            File[] services = baseDir.listFiles();
            for (int i = 0; i < services.length; ++i) {
                File service = services[i];
                if (!service.isDirectory()) continue;
                File[] forms = service.listFiles();
                for (int j = 0; j < forms.length; ++j) {
                    File form = forms[j];
                    if (!form.isDirectory()) continue;
                    File[] years = form.listFiles();
                    for (int k = 0; k < years.length; ++k) {
                        File year = years[k];
                        if (!year.isDirectory()) continue;
                        File[] versions = year.listFiles();
                        for (int l = 0; l < versions.length; ++l) {
                            File version = versions[l];
                            if (!version.isDirectory()) continue;
                            String path = version.getAbsolutePath();
                            String[] dirs = path.split(regEx);
                            StringBuffer sb = new StringBuffer();
                            sb.append(dirs[dirs.length - 4]);
                            sb.append("/");
                            sb.append(dirs[dirs.length - 3]);
                            sb.append("/");
                            sb.append(dirs[dirs.length - 2]);
                            sb.append("/");
                            sb.append(dirs[dirs.length - 1]);
                            this.keySet.add(sb.toString());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LocalFileStoreException("The RIM Artefacts directory " + baseDir.getAbsolutePath() + " is corrupt. It must be re-created.", e);
        }
    }

    public Iterator<String> getServiceIterator() {
        return this.keySet.iterator();
    }

    public static void main(String[] args) {
        try {
            FileAccessor fileAccessor = new FileAccessor("c:/LTS/RIMArtefacts");
        }
        catch (LocalFileStoreException e) {
            e.printStackTrace();
        }
    }
}

