/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class LTSCellRenderer
extends DefaultTreeCellRenderer {
    private Icon installedIcon;
    private Icon availableIcon;

    public LTSCellRenderer(Icon installedIcon, Icon availableIcon) {
        this.installedIcon = installedIcon;
        this.availableIcon = availableIcon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            String text = parent.toString();
            if (text.startsWith("Available")) {
                if (this.availableIcon != null) {
                    this.setIcon(this.availableIcon);
                }
                this.setToolTipText("Double click to install");
            } else {
                if (this.installedIcon != null) {
                    this.setIcon(this.installedIcon);
                }
                this.setToolTipText("Double click to uninstall");
            }
        } else {
            this.setToolTipText(null);
        }
        return this;
    }
}

