/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import uk.gov.hmrc.aspire.esps.common.util.NonPersistentProperties;
import uk.gov.hmrc.aspire.lts.updatemanager.About;
import uk.gov.hmrc.aspire.lts.updatemanager.ConfigUpdate;
import uk.gov.hmrc.aspire.lts.updatemanager.Help;
import uk.gov.hmrc.aspire.lts.updatemanager.LTSCellRenderer;
import uk.gov.hmrc.aspire.lts.updatemanager.LocalFileStoreException;
import uk.gov.hmrc.aspire.lts.updatemanager.Props;
import uk.gov.hmrc.aspire.lts.updatemanager.ProxyDialog;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSAccessor;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSEntry;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSException;
import uk.gov.hmrc.aspire.lts.updatemanager.ServiceModel;
import uk.gov.hmrc.aspire.lts.updatemanager.TextTransfer;

public class LTSUM
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int MIN_HEIGHT = 350;
    private static final int DIVIDER_SIZE = 6;
    public static final String LTS_ROOT_PROPERTY_NAME = "lts.root";
    private File hmrcToolsRootDir;
    private NonPersistentProperties props;
    private ServiceModel serviceBuilder;
    private ArrayList<String> notifications;
    MouseListener treeMouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            int selRow = LTSUM.this.servicesTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = LTSUM.this.servicesTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 2) {
                this.treeDoubleClicked(selRow, selPath);
                LTSUM.this.servicesTree.expandRow(selRow);
            }
        }

        private void treeDoubleClicked(int selRow, TreePath selPath) {
            if (selPath.getPathCount() != 6) {
                return;
            }
            Object[] path = selPath.getPath();
            Object baseDir = LTSUM.this.installToValueLabel.getText();
            if (!((String)baseDir).endsWith("/") && !((String)baseDir).endsWith("\\")) {
                baseDir = LTSUM.this.installToValueLabel.getText() + "/";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(path[1]);
            sb.append("/");
            sb.append(path[2]);
            sb.append("/");
            sb.append(path[3]);
            sb.append("/");
            sb.append(path[5]);
            String artefactsDir = sb.toString();
            if (path[4].toString().equals("Installed versions")) {
                this.deleteArtefacts(path, (String)baseDir, artefactsDir);
            } else {
                try {
                    this.installArtefacts(path, (String)baseDir, artefactsDir);
                }
                catch (RSSException e) {
                    LTSUM.this.statusLabel.setText("Operation failed. Please close Update Manager and try again.\n\n" + e.getMessage());
                }
            }
        }

        private void installArtefacts(Object[] path, String baseDir, String artefactsDir) throws RSSException {
            File absoluteArtefactsDir;
            if (LTSUM.this.installToValueLabel.getText().trim().equals("")) {
                LTSUM.showErrorDialog("Path must point to a valid RIM artefacts root folder");
                return;
            }
            if (LTSUM.this.vendorIDTF.getText().trim().equals("")) {
                LTSUM.showErrorDialog("Vendor Id must be entered");
                LTSUM.this.vendorIDTF.grabFocus();
                return;
            }
            File fileBase = new File(baseDir);
            if (!fileBase.exists()) {
                if (LTSUM.this.showQuestionDialog("RIM artefacts root folder " + fileBase.getAbsolutePath() + " does not exist. Do you want Update Manager to create it?") == 0) {
                    fileBase.mkdirs();
                } else {
                    return;
                }
            }
            if ((absoluteArtefactsDir = new File(baseDir + artefactsDir)).isFile()) {
                LTSUM.showErrorDialog("Path must point to a folder not a specific file");
                return;
            }
            if (absoluteArtefactsDir.exists()) {
                LTSUM.showErrorDialog("This version of the artefacts is already installed.");
                return;
            }
            File[] versions = absoluteArtefactsDir.getParentFile().listFiles();
            if (versions != null && versions.length >= 1) {
                LTSUM.showErrorDialog("A different version of these artefacts is already installed. Please remove that version first.");
                return;
            }
            String vendorId = LTSUM.this.vendorIDTF.getText().trim();
            if (vendorId.length() != 4) {
                LTSUM.showErrorDialog("Vendor Id must be four numeric digits with leading zeros");
                LTSUM.this.vendorIDTF.grabFocus();
                return;
            }
            try {
                int x = Integer.valueOf(vendorId);
                if (x < 1 || x > 9999) {
                    throw new Exception("Vendor Id must be four numeric digits with leading zeros");
                }
            }
            catch (Exception e) {
                LTSUM.showErrorDialog("Vendor Id must be four numeric digits with leading zeros");
                LTSUM.this.vendorIDTF.grabFocus();
                return;
            }
            File validatorConfig = new File(LTSUM.this.props.getProperty("validatorConfig"));
            if (!validatorConfig.exists() || !validatorConfig.isFile()) {
                String msg = "Could not find LTS configuration file " + validatorConfig.getAbsolutePath() + "\nUpdate Manager needs access to this file before new artefacts can be installed.";
                LTSUM.showErrorDialog(msg);
                return;
            }
            String dialogText = "Artefacts will be downloaded and installed into:\n\n" + absoluteArtefactsDir.getAbsolutePath() + "\n\nAre you sure you wish to continue?\n\n";
            int i = LTSUM.this.showQuestionDialog(dialogText);
            if (i == 0) {
                try {
                    LTSUM.this.props.setNonPersistentProperty("artefactsRootDirectory", LTSUM.this.installToValueLabel.getText());
                    LTSUM.this.props.setProperty("vendorid", LTSUM.this.vendorIDTF.getText());
                    Props.SaveProperties(LTSUM.this.props);
                }
                catch (LocalFileStoreException e1) {
                    LTSUM.showErrorDialog("Failed to rewrite Update Manager properties file.");
                    return;
                }
                this.doInstallArtefacts(baseDir, artefactsDir, vendorId);
                LTSUM.this.refreshTree();
                LTSUM.this.showOkDialog("RIM Artefacts have been successfully installed. \nYou must now restart the LTS server in order for these Artefacts to take effect.");
                LTSUM.this.statusLabel.setText("Version " + absoluteArtefactsDir.getAbsolutePath() + " installed.");
                validatorConfig = new File(LTSUM.this.props.getProperty("validatorConfig"));
                if (!validatorConfig.exists() || !validatorConfig.isFile()) {
                    String msg = "Could not reflect newly installed rules in the validator configuration file. " + validatorConfig.getAbsolutePath() + " is not a valid config file.";
                    LTSUM.showErrorDialog(msg);
                    return;
                }
                File serviceConfig = new File(absoluteArtefactsDir, "serviceConfig.xml");
                if (!serviceConfig.exists() || !serviceConfig.isFile()) {
                    String msg = "Could not reflect newly installed rules in the validator configuration file. " + serviceConfig.getAbsolutePath() + " is not a valid service file.";
                    LTSUM.showErrorDialog(msg);
                    return;
                }
                ConfigUpdate cu = new ConfigUpdate();
                try {
                    cu.updateService(validatorConfig, serviceConfig, new File(artefactsDir));
                }
                catch (Exception e) {
                    LTSUM.showErrorDialog("Failed to update validator config file - " + e.getMessage());
                }
            }
        }

        private void doInstallArtefacts(String baseDir, String artefactsDir, String vendorId) throws RSSException {
            LTSUM.this.statusLabel.setText("Starting installation process...");
            JarFile jarfile = null;
            String href = LTSUM.this.serviceBuilder.getRSSAccessor().getServicesRSSFeedEntry(artefactsDir).getHref();
            URL url = null;
            try {
                url = new URL("jar:" + href + "?VendorID=" + vendorId + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                jarfile = conn.getJarFile();
            }
            catch (MalformedURLException e) {
                throw new RSSException("URL " + String.valueOf(url) + " is invalid.", e);
            }
            catch (IOException e) {
                throw new RSSException("Could not read from URL " + String.valueOf(url), e);
            }
            if (jarfile == null) {
                throw new RSSException("Zip File could not be downloaded.");
            }
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                Enumeration<JarEntry> zipEnum = jarfile.entries();
                File versionDirs = new File(baseDir + artefactsDir);
                if (!versionDirs.exists()) {
                    versionDirs.mkdirs();
                }
                while (zipEnum.hasMoreElements()) {
                    int len;
                    ZipEntry item = zipEnum.nextElement();
                    if (item.isDirectory()) {
                        File newdir = new File(versionDirs, item.getName());
                        LTSUM.this.statusLabel.setText("Creating directory " + String.valueOf(newdir) + "..");
                        newdir.mkdirs();
                        continue;
                    }
                    File newFile = this.customInstallPath(artefactsDir, item.getName());
                    if (newFile == null) {
                        newFile = new File(versionDirs, item.getName());
                    }
                    LTSUM.this.statusLabel.setText("Writing " + newFile.getAbsolutePath() + "..");
                    is = jarfile.getInputStream(item);
                    fos = new FileOutputStream(newFile);
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf)) > 0) {
                        fos.write(buf, 0, len);
                    }
                    is.close();
                    fos.close();
                    LTSUM.this.statusLabel.setText("Installation complete.");
                }
            }
            catch (Exception e) {
                throw new RSSException(e.getMessage(), e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RSSException(e.getMessage(), e);
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        throw new RSSException(e.getMessage(), e);
                    }
                }
            }
        }

        private File customInstallPath(String entryKey, String filename) {
            String customInstallPath;
            File installationDir = null;
            RSSAccessor rss = LTSUM.this.serviceBuilder.getRSSAccessor();
            RSSEntry entry = rss.getServicesRSSFeedEntry(entryKey);
            Properties content = entry.getContent();
            if (content != null && (customInstallPath = content.getProperty(filename)) != null) {
                installationDir = new File(LTSUM.this.hmrcToolsRootDir, customInstallPath);
                if (!installationDir.exists()) {
                    installationDir.mkdirs();
                }
                installationDir = new File(installationDir, filename);
            }
            return installationDir;
        }

        private void deleteArtefacts(Object[] path, String baseDir, String artefactsDir) {
            File absoluteArtefactsDir = new File(baseDir + artefactsDir);
            String dialogText = "Are you sure you wish to delete artefacts:\n\n" + absoluteArtefactsDir.getAbsolutePath() + "\n\n";
            int i = LTSUM.this.showQuestionDialog(dialogText);
            if (i == 0) {
                String[] uris = this.getURIsBeforeDelete(baseDir, artefactsDir);
                if (!this.doDeleteArtefacts(baseDir, artefactsDir)) {
                    LTSUM.showErrorDialog("Failed to delete artefacts " + absoluteArtefactsDir.getAbsolutePath());
                    return;
                }
                ConfigUpdate cu = new ConfigUpdate();
                try {
                    for (String uri : uris) {
                        cu.deleteService(new File(LTSUM.this.props.getProperty("validatorConfig")), uri);
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to update validator configuration file to reflect deleted artefacts.";
                    LTSUM.showErrorDialog(msg);
                }
            }
        }

        private String[] getURIsBeforeDelete(String baseDir, String artefactsDir) {
            File serviceConfig = new File(baseDir + artefactsDir + "/serviceConfig.xml");
            if (!serviceConfig.isFile()) {
                return null;
            }
            return ConfigUpdate.getServiceURIs(serviceConfig);
        }

        private boolean doDeleteArtefacts(String baseDir, String artefactsDir) {
            String[] dirs = artefactsDir.split("/");
            File serviceDir = new File(baseDir + dirs[0]);
            File formDir = new File(baseDir + dirs[0] + "/" + dirs[1]);
            File yearDir = new File(baseDir + dirs[0] + "/" + dirs[1] + "/" + dirs[2]);
            File versionDir = new File(baseDir + artefactsDir);
            this.doRecursiveDeleteDirectories(versionDir);
            this.doDeleteDirectory(versionDir);
            this.doDeleteDirectory(yearDir);
            this.doDeleteDirectory(formDir);
            this.doDeleteDirectory(serviceDir);
            LTSUM.this.refreshTree();
            LTSUM.this.statusLabel.setText("Version " + versionDir.getAbsolutePath() + " deleted.");
            return true;
        }

        private boolean doDeleteDirectory(File dir) {
            File[] files = dir.listFiles();
            if (files == null || files.length == 0) {
                return dir.delete();
            }
            return false;
        }

        private void doRecursiveDeleteDirectories(File dir) {
            int i;
            File[] files = dir.listFiles();
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                this.doRecursiveDeleteDirectories(files[i]);
            }
            for (i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    };
    MouseListener notificationsMouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (LTSUM.this.notificationsList.getSelectedIndex() == -1) {
                return;
            }
            String notificationTitle = (String)LTSUM.this.notificationsList.getSelectedValue();
            String url = LTSUM.this.serviceBuilder.getRSSAccessor().getNotificationEntry(notificationTitle).getHref();
            LTSUM.this.statusLabel.setText(url);
            if (e.getClickCount() == 2) {
                TextTransfer clipboard = new TextTransfer();
                clipboard.setClipboardContents(url);
                JOptionPane.showMessageDialog(new JFrame(), "URL copied to clipboard.", "LTS Update Manager", 1);
            }
        }
    };
    private JMenuItem aboutMI;
    private JMenuItem settingsMI;
    private JMenuItem refreshMI;
    private JMenuItem exitMI;
    private JMenu fileMenu;
    private JMenu optionsMenu;
    private JMenuItem helpMI;
    private JMenu helpMenu;
    private JLabel installLabel;
    private JLabel installToValueLabel;
    private JLabel logo;
    private JPanel logoPanel;
    private JMenuBar menuBar;
    private JList notificationsList;
    private JScrollPane notificationsScroll;
    private JTree servicesTree;
    private JSplitPane splitPane;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JPanel toolsPanel;
    private JPanel topPanel;
    private JScrollPane treeScroll;
    private JTextField vendorIDTF;
    private JLabel vendorLabel;
    private ProxyDialog settingsDialog;

    public LTSUM(File hmrcToolsRootDir, NonPersistentProperties props) {
        this.hmrcToolsRootDir = hmrcToolsRootDir;
        this.props = props;
        String proxyHost = props.getProperty("proxy.hostname");
        String proxyPort = props.getProperty("proxy.port");
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyPort.length() > 0) {
            System.setProperty("https.proxyHost", proxyHost);
            System.setProperty("https.proxyPort", proxyPort);
        }
        this.initComponents();
        ToolTipManager.sharedInstance().registerComponent(this.servicesTree);
        ImageIcon installedIcon = new ImageIcon(this.getClass().getResource("/installed.png"));
        ImageIcon availableIcon = new ImageIcon(this.getClass().getResource("/available.png"));
        this.servicesTree.setCellRenderer(new LTSCellRenderer((Icon)installedIcon, availableIcon));
    }

    private void initComponents() {
        String decoded;
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.splitPane = new JSplitPane();
        this.topPanel = new JPanel();
        this.treeScroll = new JScrollPane();
        this.servicesTree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.toolsPanel = new JPanel();
        this.installLabel = new JLabel();
        this.installToValueLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.vendorIDTF = new JTextField();
        this.logoPanel = new JPanel();
        this.logo = new JLabel();
        this.notificationsScroll = new JScrollPane();
        this.notificationsList = new JList();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.refreshMI = new JMenuItem();
        this.exitMI = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.settingsMI = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMI = new JMenuItem();
        this.aboutMI = new JMenuItem();
        this.settingsDialog = new ProxyDialog(this);
        String[] usernamePassword = null;
        String authentication = this.props.getProperty("proxy.authentication");
        if (authentication != null && authentication.length() > 0 && (decoded = new String(Base64.getDecoder().decode(authentication))) != null && decoded.length() > 0) {
            usernamePassword = decoded.split(":");
        }
        this.settingsDialog.setValues(this.props.getProperty("proxy.hostname") != null && this.props.getProperty("proxy.hostname").length() > 0 && this.props.getProperty("proxy.port") != null && this.props.getProperty("proxy.port").length() > 0, this.props.getProperty("proxy.hostname"), this.props.getProperty("proxy.port"), usernamePassword != null && usernamePassword.length > 0, usernamePassword != null && usernamePassword.length >= 1 ? usernamePassword[0] : null, usernamePassword != null && usernamePassword.length >= 2 ? usernamePassword[1] : null, usernamePassword != null && usernamePassword.length > 0);
        this.servicesTree.addMouseListener(this.treeMouseListener);
        this.setDefaultCloseOperation(3);
        if (!this.settingsDialog.isEnableProxy()) {
            this.setTitle("LTS Update Manager");
        } else {
            this.setTitle("LTS Update Manager - Proxy [" + this.settingsDialog.getHostname() + ":" + this.settingsDialog.getPort() + "]");
        }
        this.statusPanel.setLayout(new BorderLayout());
        this.statusLabel.setBackground(new Color(255, 255, 255));
        this.statusLabel.setText("Downloading information...");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.statusPanel.add((Component)this.statusLabel, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.splitPane.setDividerSize(6);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setOrientation(0);
        this.splitPane.setOneTouchExpandable(true);
        this.topPanel.setLayout(new BorderLayout(5, 5));
        this.treeScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Services"));
        this.installToValueLabel.setText(this.props.getProperty("artefactsRootDirectory"));
        this.installToValueLabel.setToolTipText("Local RIM Artefacts installation directory");
        this.refreshTree();
        this.statusLabel.setText("");
        this.servicesTree.setRootVisible(false);
        this.treeScroll.setViewportView(this.servicesTree);
        this.treeScroll.setMinimumSize(new Dimension(100, 75));
        this.topPanel.add((Component)this.treeScroll, "Center");
        this.toolsPanel.setLayout(new GridBagLayout());
        this.installLabel.setText("Install to:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.toolsPanel.add((Component)this.installLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.toolsPanel.add((Component)this.installToValueLabel, gridBagConstraints);
        this.vendorLabel.setText("Vendor ID:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 30, 5, 5);
        this.toolsPanel.add((Component)this.vendorLabel, gridBagConstraints);
        this.vendorIDTF.setColumns(5);
        this.vendorIDTF.setText(this.props.getProperty("vendorid"));
        this.vendorIDTF.setMinimumSize(this.vendorIDTF.getSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.toolsPanel.add((Component)this.vendorIDTF, gridBagConstraints);
        JPanel spacerPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.toolsPanel.add((Component)spacerPanel, gridBagConstraints);
        this.topPanel.add((Component)this.toolsPanel, "South");
        this.logoPanel.setLayout(new BorderLayout());
        this.logoPanel.setBackground(new Color(0, 156, 99));
        this.logo.setBackground(new Color(0, 156, 99));
        this.logo.setForeground(new Color(0, 156, 99));
        this.logo.setOpaque(true);
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/logo.gif")));
        this.logoPanel.add((Component)this.logo, "Center");
        this.topPanel.add((Component)this.logoPanel, "North");
        this.splitPane.setTopComponent(this.topPanel);
        this.notificationsScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Notifications"));
        this.notificationsList.addMouseListener(this.notificationsMouseListener);
        this.notificationsList.setToolTipText("Double-click an item to obtain the url for use via your web browser");
        this.notificationsList.setMinimumSize(new Dimension(100, 75));
        this.notificationsScroll.setViewportView(this.notificationsList);
        this.notificationsScroll.setMinimumSize(new Dimension(100, 75));
        this.notificationsScroll.setPreferredSize(new Dimension(100, 75));
        this.refreshNotifications();
        this.splitPane.setBottomComponent(this.notificationsScroll);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.refreshMI.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.refreshMI.setMnemonic('R');
        this.refreshMI.setText("Refresh");
        this.refreshMI.setToolTipText("Refresh from RSS Feed");
        this.refreshMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LTSUM.this.refreshMIActionPerformed();
            }
        });
        this.fileMenu.add(this.refreshMI);
        this.exitMI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.exitMI.setMnemonic('X');
        this.exitMI.setText("Exit");
        this.exitMI.setToolTipText("Exit the application");
        this.exitMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LTSUM.this.exitMIActionPerformed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LTSUM.this.exitMIActionPerformed();
            }
        });
        this.fileMenu.add(this.exitMI);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.helpMI.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.helpMI.setMnemonic('H');
        this.helpMI.setText("Help...");
        this.helpMI.setToolTipText("Show built-in help");
        this.helpMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LTSUM.this.helpMIActionPerformed(evt);
            }
        });
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.setText("Options");
        this.settingsMI.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.settingsMI.setMnemonic('S');
        this.settingsMI.setText("Settings...");
        this.settingsMI.setToolTipText("View/Edit configuration settings");
        this.settingsMI.addActionListener(new SettingsActionListener());
        this.optionsMenu.add(this.settingsMI);
        this.menuBar.add(this.optionsMenu);
        this.helpMenu.add(this.helpMI);
        this.aboutMI.setMnemonic('A');
        this.aboutMI.setText("About...");
        this.aboutMI.setToolTipText("Show version information");
        this.aboutMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LTSUM.this.showAbout(evt);
            }
        });
        this.helpMenu.add(this.aboutMI);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int MAX_HEIGHT = screenSize.height - 50;
        this.doSizing(MAX_HEIGHT, 350);
        this.positionFrame();
    }

    protected void positionFrame() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    protected void positionDivider(int maxHeight) {
        int insetsAndPadding = 45;
        int collectiveHeight = this.servicesTree.getHeight() > 100 ? this.servicesTree.getHeight() : 100;
        collectiveHeight += this.logoPanel.getHeight();
        if ((collectiveHeight += this.toolsPanel.getHeight()) <= maxHeight) {
            int bottomPanePreferredSize = this.notificationsList.getSize().height;
            int bottomPaneSize = this.splitPane.getHeight() - 6 - (collectiveHeight + insetsAndPadding);
            int diff = bottomPanePreferredSize - bottomPaneSize;
            if (diff <= 0) {
                this.splitPane.setDividerLocation(collectiveHeight + insetsAndPadding);
            } else {
                this.splitPane.setDividerLocation(collectiveHeight + insetsAndPadding - diff);
            }
        } else {
            int dividerPosition = this.splitPane.getHeight() - 6 - this.notificationsList.getSize().height;
            if (dividerPosition > this.treeScroll.getMinimumSize().height + this.toolsPanel.getHeight() + insetsAndPadding) {
                this.splitPane.setDividerLocation(dividerPosition);
            } else {
                this.splitPane.setDividerLocation(0.75);
            }
        }
    }

    protected void doSizing(int maxHeight, final int minHeight) {
        int height = 0;
        this.pack();
        height = this.getHeight();
        if (height > maxHeight) {
            height = maxHeight;
        }
        this.getContentPane().setPreferredSize(new Dimension(this.getWidth(), height));
        this.pack();
        this.addComponentListener(new ComponentAdapter(){
            final int initialWidth;
            {
                this.initialWidth = LTSUM.this.getWidth();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                LTSUM.this.setSize(Math.max(this.initialWidth, LTSUM.this.getWidth()), Math.max(minHeight, LTSUM.this.getHeight()));
            }
        });
    }

    private void showAbout(ActionEvent evt) {
        About about = new About(new JFrame("About"));
        about.setVisible(true);
    }

    private void helpMIActionPerformed(ActionEvent evt) {
        Help f1 = new Help(new JFrame("Help"));
        f1.setVisible(true);
    }

    private void exitMIActionPerformed() {
        try {
            Props.SaveProperties(this.props);
        }
        catch (LocalFileStoreException e) {
            LTSUM.showErrorDialog(e.getMessage());
        }
        System.exit(0);
    }

    private void refreshMIActionPerformed() {
        this.refreshTree();
        this.refreshNotifications();
    }

    private void refreshNotifications() {
        AbstractListModel listModel = this.notificationsModel();
        if (listModel != null) {
            this.notificationsList.setModel(listModel);
        }
    }

    private void refreshTree() {
        try {
            this.serviceBuilder = new ServiceModel(this.props, this.installToValueLabel.getText());
            this.servicesTree.setModel(this.serviceBuilder);
            for (int i = 0; i < this.servicesTree.getRowCount(); ++i) {
                this.servicesTree.expandRow(i);
            }
            this.statusLabel.setText("Services refreshed");
        }
        catch (RSSException e) {
            this.statusLabel.setText(e.getMessage());
            LTSUM.showErrorDialog("Could not access resource " + this.props.getProperty("rssfeedurl") + "  \n\nIf this address is correct then please try again later, otherwise change the address \nin the Update Manager configuration file 'updatemanagerconfig.properties' and retry.\n\nThere may be a Proxy Server in place that is preventing direct access to the above URL.\nIf this is the case then you will need to configure the Update Manager to enable Proxy usage.");
        }
        catch (LocalFileStoreException e) {
            LTSUM.showErrorDialog(e.getMessage());
            System.exit(1);
        }
    }

    private AbstractListModel notificationsModel() {
        RSSAccessor rssFeed;
        AbstractListModel alm = null;
        if (this.serviceBuilder != null && (rssFeed = this.serviceBuilder.getRSSAccessor()) != null) {
            this.notifications = new ArrayList();
            Iterator<String> iterator = rssFeed.getNotificationsIterator();
            while (iterator.hasNext()) {
                this.notifications.add(iterator.next());
            }
            alm = new AbstractListModel(){

                @Override
                public int getSize() {
                    return LTSUM.this.notifications.size();
                }

                @Override
                public Object getElementAt(int i) {
                    return LTSUM.this.notifications.get(i);
                }
            };
        }
        return alm;
    }

    public static void main(String[] args) {
        File ltsRootDir;
        String ltsRoot;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (args[0] == null || args[0].trim().length() == 0) {
            LTSUM.showErrorDialog("Missing command line argument - properties file");
            System.exit(1);
        }
        if ((ltsRoot = System.getProperty(LTS_ROOT_PROPERTY_NAME)) == null || ltsRoot.trim().length() == 0) {
            LTSUM.showErrorDialog("You Must set the LTS_HOME variable - please consult the Installation guide");
            System.exit(1);
        }
        if (!((ltsRootDir = new File(ltsRoot)).exists() && ltsRootDir.isDirectory() && ltsRootDir.canRead())) {
            LTSUM.showErrorDialog("Missing, invalid or inaccessible directory (environment variable 'LTS_HOME'): " + ltsRootDir.getAbsolutePath());
            System.exit(1);
        }
        final File hmrcToolsRoot = ltsRootDir.getAbsoluteFile().getParentFile();
        final NonPersistentProperties props = Props.loadProperties(new File(args[0]), hmrcToolsRoot);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LTSUM ltsum = new LTSUM(hmrcToolsRoot, props);
                ltsum.setVisible(true);
            }
        });
    }

    private void showOkDialog(String msg) {
        JOptionPane.showMessageDialog(new JFrame(), msg, "LTS Update Manager", 1);
    }

    private static void showErrorDialog(String msg) {
        JOptionPane.showMessageDialog(new JFrame(), msg, "LTS Update Manager", 0);
    }

    private int showQuestionDialog(String msg) {
        return JOptionPane.showConfirmDialog(new JFrame(), msg, "LTS Update Manager", 0, 3);
    }

    class SettingsActionListener
    implements ActionListener {
        SettingsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LTSUM.this.statusLabel.setText("View/Edit settings...");
            LTSUM.this.settingsDialog.setVisible(true);
            if (LTSUM.this.settingsDialog.isChangedMade()) {
                if (LTSUM.this.settingsDialog.isEnableProxy()) {
                    System.setProperty("https.proxyHost", LTSUM.this.settingsDialog.getHostname());
                    System.setProperty("https.proxyPort", LTSUM.this.settingsDialog.getPort());
                    LTSUM.this.props.setProperty("proxy.hostname", LTSUM.this.settingsDialog.getHostname());
                    LTSUM.this.props.setProperty("proxy.port", LTSUM.this.settingsDialog.getPort());
                    if (LTSUM.this.settingsDialog.isEnableAuthentication()) {
                        String user = LTSUM.this.settingsDialog.getUsername();
                        String pass = LTSUM.this.settingsDialog.getPassword();
                        if (user != null && user.length() > 0) {
                            String authenticationDetails = Base64.getEncoder().encodeToString((user + ":" + (pass != null ? pass : "")).getBytes());
                            if (LTSUM.this.settingsDialog.isSaveUserDetails()) {
                                LTSUM.this.props.setProperty("proxy.authentication", authenticationDetails);
                            } else {
                                LTSUM.this.props.remove("proxy.authentication");
                                LTSUM.this.props.setNonPersistentProperty("proxy.authentication", authenticationDetails);
                            }
                        }
                    } else {
                        LTSUM.this.props.remove("proxy.authentication");
                    }
                    LTSUM.this.setTitle("LTS Update Manager - Proxy [" + LTSUM.this.settingsDialog.getHostname() + ":" + LTSUM.this.settingsDialog.getPort() + "]");
                } else {
                    System.setProperty("https.proxyHost", "");
                    System.setProperty("https.proxyPort", "");
                    LTSUM.this.setTitle("LTS Update Manager");
                }
                LTSUM.this.refreshMIActionPerformed();
                LTSUM.this.statusLabel.setText("Settings changed.");
            } else {
                LTSUM.this.statusLabel.setText("Settings not changed.");
            }
        }
    }
}

