/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import uk.gov.hmrc.aspire.esps.common.util.NonPersistentProperties;
import uk.gov.hmrc.aspire.lts.updatemanager.LocalFileStoreException;

public class Props {
    private static File propsFile;

    public static NonPersistentProperties loadProperties(File propertiesFile, File hmrcToolsRootDir) {
        NonPersistentProperties props = null;
        try {
            props = new NonPersistentProperties();
            props.load(new FileInputStream(propertiesFile));
            propsFile = propertiesFile;
            String artefactsRootDir = props.getProperty("artefactsRootDirectory");
            artefactsRootDir = new File(hmrcToolsRootDir.getAbsolutePath(), artefactsRootDir).getAbsolutePath();
            props.setNonPersistentProperty("artefactsRootDirectory", artefactsRootDir);
            String validatorConfig = props.getProperty("validatorConfig");
            validatorConfig = new File(hmrcToolsRootDir.getAbsolutePath(), validatorConfig).getAbsolutePath();
            props.setNonPersistentProperty("validatorConfig", validatorConfig);
        }
        catch (Exception e) {
            Logger.global.severe("Failed to load properties file " + String.valueOf(e));
        }
        return props;
    }

    public static void SaveProperties(Properties props) throws LocalFileStoreException {
        try {
            FileOutputStream fos = new FileOutputStream(propsFile);
            props.store(fos, "Updated by Update Manager");
        }
        catch (FileNotFoundException e) {
            throw new LocalFileStoreException("Could not find Update Manager configuration file " + propsFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new LocalFileStoreException("Could not rewrite Update Manager configuration file " + propsFile.getAbsolutePath());
        }
    }

    public static String getStringProp(Properties props, String id, boolean optional) {
        try {
            Object o = props.get(id);
            if (o == null && !optional) {
                throw new RuntimeException("The mandatory property was not set in the properties file.");
            }
            return (String)o;
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem reading the property " + id, e);
        }
    }

    public static boolean getBoolProp(Properties props, String id, boolean optional) {
        String s = Props.getStringProp(props, id, optional);
        return s == null ? false : s.trim().toLowerCase().equals("true");
    }

    public static int getIntProp(Properties props, String id, boolean optional) {
        try {
            Object o = props.get(id);
            if (o == null && !optional) {
                throw new RuntimeException("The mandatory property was not set in the properties file.");
            }
            if (o == null) {
                return -1;
            }
            return Integer.parseInt((String)o);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem reading the property " + id, e);
        }
    }
}

