/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ProxyDialog
extends JDialog {
    private static final String ENABLED_PROPERTY = "enabled";
    private boolean enableProxy = false;
    private boolean enableAuthentication = false;
    private boolean saveUserDetails;
    private String hostname;
    private String port;
    private String username;
    private String password;
    private JCheckBox enableProxyWidget;
    private JLabel hostnameLabel;
    private JTextField hostnameWidget;
    private JLabel portLabel;
    private JTextField portWidget;
    private JCheckBox enableAuthenticationWidget;
    private JLabel usernameLabel;
    private JTextField usernameWidget;
    private JLabel passwordLabel;
    private JPasswordField passwordWidget;
    private JCheckBox saveUserDetailsWidget;
    private JPanel authenticationPane;
    private JPanel buttonPane;
    private JPanel proxyPane;
    private JButton confirmButton;
    private JButton cancelButton;
    private boolean changesMade;

    public ProxyDialog(JFrame owner) {
        super(owner, "Proxy Server Settings", true);
        this.init();
    }

    public void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.proxyPane = new JPanel(new GridBagLayout());
        this.proxyPane.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.proxyPane, gbc);
        this.buttonPane = new JPanel(new GridLayout(1, 2, 5, 0));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPane, gbc);
        this.enableProxyWidget = new JCheckBox("Use Proxy Server");
        this.enableProxyWidget.addActionListener(new ProxyWidgetListener());
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.proxyPane.add((Component)this.enableProxyWidget, gbc);
        this.hostnameLabel = new JLabel("Hostname");
        this.hostnameLabel.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = -1;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 25, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.proxyPane.add((Component)this.hostnameLabel, gbc);
        this.hostnameWidget = new JTextField();
        this.hostnameWidget.setColumns(20);
        this.hostnameWidget.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.proxyPane.add((Component)this.hostnameWidget, gbc);
        this.portLabel = new JLabel("Port");
        this.portLabel.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = -1;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 25, 5, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.proxyPane.add((Component)this.portLabel, gbc);
        this.portWidget = new JTextField();
        this.portWidget.setColumns(10);
        this.portWidget.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.proxyPane.add((Component)this.portWidget, gbc);
        this.authenticationPane = new JPanel(new GridBagLayout());
        this.authenticationPane.setBorder(BorderFactory.createEtchedBorder());
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 25, 5, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.proxyPane.add((Component)this.authenticationPane, gbc);
        this.enableAuthenticationWidget = new JCheckBox("Authentication Required");
        this.enableAuthenticationWidget.setEnabled(false);
        this.enableAuthenticationWidget.addActionListener(new AuthenticationWidgetListener());
        this.enableAuthenticationWidget.addPropertyChangeListener(ENABLED_PROPERTY, new AuthenticationWidgetPropertyListener());
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.authenticationPane.add((Component)this.enableAuthenticationWidget, gbc);
        this.usernameLabel = new JLabel("Username");
        this.usernameLabel.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = -1;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 25, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.authenticationPane.add((Component)this.usernameLabel, gbc);
        this.usernameWidget = new JTextField();
        this.usernameWidget.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.authenticationPane.add((Component)this.usernameWidget, gbc);
        this.passwordLabel = new JLabel("Password");
        this.passwordLabel.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = -1;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 25, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.authenticationPane.add((Component)this.passwordLabel, gbc);
        this.passwordWidget = new JPasswordField();
        this.passwordWidget.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.authenticationPane.add((Component)this.passwordWidget, gbc);
        this.saveUserDetailsWidget = new JCheckBox("Save authentication details");
        this.saveUserDetailsWidget.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.insets = new Insets(5, 25, 5, 5);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.authenticationPane.add((Component)this.saveUserDetailsWidget, gbc);
        this.confirmButton = new JButton(new ConfirmAction());
        this.buttonPane.add(this.confirmButton);
        this.cancelButton = new JButton(new CancelAction());
        this.buttonPane.add(this.cancelButton);
        this.doSizing();
    }

    public void setValues(boolean enableProxy, String hostname, String port, boolean enableAuthentication, String username, String password, boolean saveUserDetails) {
        this.enableProxy = enableProxy;
        this.hostname = hostname;
        this.port = port;
        this.enableAuthentication = enableAuthentication;
        this.username = username;
        this.password = password;
        this.saveUserDetails = saveUserDetails;
        this.enableProxyWidget.setSelected(enableProxy);
        this.hostnameWidget.setText(hostname);
        this.portWidget.setText(port);
        this.enableAuthenticationWidget.setSelected(enableAuthentication);
        this.usernameWidget.setText(username);
        this.passwordWidget.setText(password);
        this.saveUserDetailsWidget.setSelected(saveUserDetails);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.hostnameLabel.setEnabled(this.enableProxy);
            this.hostnameWidget.setEnabled(this.enableProxy);
            this.portLabel.setEnabled(this.enableProxy);
            this.portWidget.setEnabled(this.enableProxy);
            this.enableAuthenticationWidget.setEnabled(this.enableProxy);
            if (this.enableProxy) {
                this.usernameLabel.setEnabled(this.enableAuthentication);
                this.usernameWidget.setEnabled(this.enableAuthentication);
                this.passwordLabel.setEnabled(this.enableAuthentication);
                this.passwordWidget.setEnabled(this.enableAuthentication);
                this.saveUserDetailsWidget.setEnabled(this.enableAuthentication);
            } else {
                this.usernameLabel.setEnabled(false);
                this.usernameWidget.setEnabled(false);
                this.passwordLabel.setEnabled(false);
                this.passwordWidget.setEnabled(false);
                this.saveUserDetailsWidget.setEnabled(false);
            }
            Point parentLocation = this.getParent().getLocation();
            Dimension parentSize = this.getParent().getSize();
            Dimension dialogSize = this.getSize();
            int x = parentLocation.x + (parentSize.width - dialogSize.width) / 2;
            int y = parentLocation.y + (parentSize.height - dialogSize.height) / 2;
            this.setLocation(x, y);
        }
        super.setVisible(visible);
    }

    private void doSizing() {
        this.pack();
        final int fixedHeight = this.getHeight();
        final int minWidth = this.getWidth();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                ProxyDialog.this.setSize(Math.max(minWidth, ProxyDialog.this.getWidth()), fixedHeight);
            }
        });
    }

    public boolean isChangedMade() {
        return this.changesMade;
    }

    public boolean isEnableAuthentication() {
        return this.enableAuthentication;
    }

    public boolean isEnableProxy() {
        return this.enableProxy;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPassword() {
        return new String(this.password);
    }

    public String getPort() {
        return this.port;
    }

    public boolean isSaveUserDetails() {
        return this.saveUserDetails;
    }

    public String getUsername() {
        return this.username;
    }

    class ProxyWidgetListener
    implements ActionListener {
        ProxyWidgetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ProxyDialog.this.hostnameLabel.setEnabled(ProxyDialog.this.enableProxyWidget.isSelected());
            ProxyDialog.this.hostnameWidget.setEnabled(ProxyDialog.this.enableProxyWidget.isSelected());
            ProxyDialog.this.portLabel.setEnabled(ProxyDialog.this.enableProxyWidget.isSelected());
            ProxyDialog.this.portWidget.setEnabled(ProxyDialog.this.enableProxyWidget.isSelected());
            ProxyDialog.this.enableAuthenticationWidget.setEnabled(ProxyDialog.this.enableProxyWidget.isSelected());
        }
    }

    class AuthenticationWidgetListener
    implements ActionListener {
        AuthenticationWidgetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ProxyDialog.this.enableProxyWidget.isSelected()) {
                ProxyDialog.this.usernameLabel.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                ProxyDialog.this.usernameWidget.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                ProxyDialog.this.passwordLabel.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                ProxyDialog.this.passwordWidget.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                ProxyDialog.this.saveUserDetailsWidget.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
            } else {
                ProxyDialog.this.usernameLabel.setEnabled(false);
                ProxyDialog.this.usernameWidget.setEnabled(false);
                ProxyDialog.this.passwordLabel.setEnabled(false);
                ProxyDialog.this.passwordWidget.setEnabled(false);
                ProxyDialog.this.saveUserDetailsWidget.setEnabled(false);
            }
        }
    }

    class AuthenticationWidgetPropertyListener
    implements PropertyChangeListener {
        AuthenticationWidgetPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (ProxyDialog.ENABLED_PROPERTY.equals(event.getPropertyName())) {
                if (((Boolean)event.getNewValue()).booleanValue()) {
                    if (ProxyDialog.this.enableProxyWidget.isSelected()) {
                        ProxyDialog.this.usernameLabel.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                        ProxyDialog.this.usernameWidget.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                        ProxyDialog.this.passwordLabel.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                        ProxyDialog.this.passwordWidget.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                        ProxyDialog.this.saveUserDetailsWidget.setEnabled(ProxyDialog.this.enableAuthenticationWidget.isSelected());
                    }
                } else {
                    ProxyDialog.this.usernameLabel.setEnabled(false);
                    ProxyDialog.this.usernameWidget.setEnabled(false);
                    ProxyDialog.this.passwordLabel.setEnabled(false);
                    ProxyDialog.this.passwordWidget.setEnabled(false);
                    ProxyDialog.this.saveUserDetailsWidget.setEnabled(false);
                }
            }
        }
    }

    class ConfirmAction
    extends AbstractAction {
        public ConfirmAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ProxyDialog.this.enableProxy = ProxyDialog.this.enableProxyWidget.isSelected();
            ProxyDialog.this.hostname = ProxyDialog.this.hostnameWidget.getText();
            ProxyDialog.this.port = ProxyDialog.this.portWidget.getText();
            ProxyDialog.this.enableAuthentication = ProxyDialog.this.enableAuthenticationWidget.isSelected();
            ProxyDialog.this.username = ProxyDialog.this.usernameWidget.getText();
            ProxyDialog.this.password = new String(ProxyDialog.this.passwordWidget.getPassword());
            ProxyDialog.this.saveUserDetails = ProxyDialog.this.saveUserDetailsWidget.isSelected();
            ProxyDialog.this.changesMade = true;
            ProxyDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ProxyDialog.this.enableProxyWidget.setSelected(ProxyDialog.this.enableProxy);
            ProxyDialog.this.hostnameWidget.setText(ProxyDialog.this.hostname);
            ProxyDialog.this.portWidget.setText(ProxyDialog.this.port);
            ProxyDialog.this.enableAuthenticationWidget.setSelected(ProxyDialog.this.enableAuthentication);
            ProxyDialog.this.usernameWidget.setText(ProxyDialog.this.username);
            ProxyDialog.this.passwordWidget.setText(ProxyDialog.this.password);
            ProxyDialog.this.saveUserDetailsWidget.setSelected(ProxyDialog.this.saveUserDetails);
            ProxyDialog.this.changesMade = false;
            ProxyDialog.this.setVisible(false);
        }
    }
}

