/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import uk.gov.hmrc.aspire.lts.updatemanager.Props;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSEntry;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSException;

public class RSSAccessor {
    private SortedMap<String, RSSEntry> serviceEntries = new TreeMap<String, RSSEntry>();
    private SortedMap<String, RSSEntry> notificationEntries = new TreeMap<String, RSSEntry>();

    public RSSAccessor(Properties props) throws RSSException {
        String urlString = Props.getStringProp(props, "rssfeedurl", false);
        if (urlString.startsWith("file:///")) {
            this.getRSSFeedFromFile(urlString);
        } else {
            this.getRSSFeed(urlString, props.getProperty("proxy.authentication"));
        }
    }

    private void getRSSFeed(String urlString, String authentication) throws RSSException {
        try {
            String[] usernamePassword;
            String decoded;
            URL url = new URL(urlString);
            URLConnection urlc = url.openConnection();
            HttpURLConnection con = (HttpURLConnection)urlc;
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("GET");
            if (authentication != null && authentication.length() > 0 && (decoded = new String(Base64.getDecoder().decode(authentication))) != null && decoded.length() > 0 && (usernamePassword = decoded.split(":")).length > 0 && usernamePassword[0] != null && usernamePassword[0].length() > 0) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(usernamePassword[0], usernamePassword.length >= 2 && usernamePassword[1] != null ? usernamePassword[1].toCharArray() : new char[]{});
                    }
                });
            }
            BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
            this.loadRSSFeedXml(bis);
            bis.close();
            con.disconnect();
        }
        catch (IOException e) {
            throw new RSSException("Problems encountered trying to get RSS feed document. " + e.getMessage(), e);
        }
    }

    private void getRSSFeedFromFile(String urlString) throws RSSException {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new URL(urlString).getFile()));
            this.loadRSSFeedXml(bis);
            bis.close();
        }
        catch (IOException e) {
            throw new RSSException("Problems encountered trying to get RSS feed document. " + e.getMessage(), e);
        }
    }

    private void loadRSSFeedXml(InputStream rssFeedFile) throws RSSException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(rssFeedFile);
        }
        catch (JDOMException e) {
            throw new RSSException("Could not get Parser to parse RSS feed document. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RSSException("Could not parse input RSS feed document. " + e.getMessage(), e);
        }
        Element root = doc.getRootElement();
        Namespace ns = root.getNamespace();
        List list = root.getChildren("entry", ns);
        for (int i = 0; i < list.size(); ++i) {
            RSSEntry se = new RSSEntry();
            Element entryNode = (Element)list.get(i);
            Element currElement = entryNode.getChild("title", ns);
            if (currElement == null) {
                throw new RSSException("title is missing in RSS feed file.");
            }
            se.setTitle(currElement.getTextTrim());
            String value = entryNode.getChild("category", ns).getAttribute("term").getValue();
            if (value == null) {
                throw new RSSException("Attribute term missing for element category in RSS feed file.");
            }
            se.setTerm(value);
            value = entryNode.getChild("link", ns).getAttribute("rel").getValue();
            if (value == null) {
                throw new RSSException("Attribute rel missing for element link in RSS feed file.");
            }
            se.setRel(value);
            value = entryNode.getChild("link", ns).getAttribute("type").getValue();
            if (value == null) {
                throw new RSSException("Attribute type missing for element link in RSS feed file.");
            }
            se.setType(value);
            value = entryNode.getChild("link", ns).getAttribute("href").getValue();
            if (value == null) {
                throw new RSSException("Attribute href missing for element link in RSS feed file.");
            }
            se.setHref(value);
            currElement = entryNode.getChild("id", ns);
            if (currElement == null) {
                throw new RSSException("id is missing in RSS feed file.");
            }
            se.setId(currElement.getTextTrim());
            currElement = entryNode.getChild("updated", ns);
            if (currElement == null) {
                throw new RSSException("updated is missing in RSS feed file.");
            }
            se.setUpdated(currElement.getTextTrim());
            currElement = entryNode.getChild("content", ns);
            if (currElement != null) {
                se.setContent(currElement.getTextTrim());
            }
            if (se.getTerm().equals("Notification")) {
                this.notificationEntries.put(se.getTitle(), se);
                continue;
            }
            this.serviceEntries.put(se.getTerm(), se);
        }
    }

    public Iterator<String> getServiceIterator() {
        return this.serviceEntries.keySet().iterator();
    }

    public RSSEntry getServicesRSSFeedEntry(String key) {
        return (RSSEntry)this.serviceEntries.get(key);
    }

    public Iterator<String> getNotificationsIterator() {
        return this.notificationEntries.keySet().iterator();
    }

    public RSSEntry getNotificationEntry(String key) {
        return (RSSEntry)this.notificationEntries.get(key);
    }
}

