/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.updatemanager;

import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import uk.gov.hmrc.aspire.lts.updatemanager.FileAccessor;
import uk.gov.hmrc.aspire.lts.updatemanager.LocalFileStoreException;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSAccessor;
import uk.gov.hmrc.aspire.lts.updatemanager.RSSException;

public class ServiceModel
extends DefaultTreeModel {
    static final long serialVersionUID = 0L;
    private static RSSAccessor feed = null;
    DefaultMutableTreeNode serviceNode = null;
    DefaultMutableTreeNode formNode = null;
    DefaultMutableTreeNode yearNode = null;
    DefaultMutableTreeNode installedOrAvailableNode = null;
    DefaultMutableTreeNode versionNode = null;
    String service = null;
    String form = null;
    String year = null;
    String iv = null;
    String version = null;

    public ServiceModel(Properties props, String baseDirectory) throws RSSException, LocalFileStoreException {
        super(new DefaultMutableTreeNode("Services"));
        Object key;
        feed = new RSSAccessor(props);
        FileAccessor local = new FileAccessor(baseDirectory);
        DefaultMutableTreeNode services = (DefaultMutableTreeNode)this.root;
        TreeSet<Object> keySet = new TreeSet<Object>();
        Iterator<String> iterator = feed.getServiceIterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            String[] stringArray = ((String)key).split("/");
            key = stringArray[0] + "/" + stringArray[1] + "/" + stringArray[2] + "/Available versions/" + stringArray[3];
            keySet.add(key);
        }
        iterator = local.getServiceIterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            String[] stringArray = ((String)key).split("/");
            key = stringArray[0] + "/" + stringArray[1] + "/" + stringArray[2] + "/Installed versions/" + stringArray[3];
            keySet.add(key);
        }
        boolean isFirstTime = true;
        for (String string : keySet) {
            String[] nodeText2 = string.split("/");
            if (nodeText2.length != 5) {
                if (nodeText2[3].equals("Installed versions")) {
                    throw new LocalFileStoreException("The 'Install To' must point to a base directory containing RIM artefacts.");
                }
                throw new RSSException("The term attribute in the RSS feed document must contain service/form/year/version info separated by the / character.");
            }
            if (isFirstTime) {
                this.resetServiceNode(nodeText2);
                this.resetKeyChangedVariables(nodeText2);
                isFirstTime = false;
            }
            if (!nodeText2[0].equals(this.service)) {
                this.addServiceNodeToTree(services);
                this.resetServiceNode(nodeText2);
                this.resetKeyChangedVariables(nodeText2);
                continue;
            }
            if (!nodeText2[1].equals(this.form)) {
                this.addFormNodeToTree();
                this.resetFormNode(nodeText2);
                this.resetKeyChangedVariables(nodeText2);
                continue;
            }
            if (!nodeText2[2].equals(this.year)) {
                this.addYearNodeToTree();
                this.resetYearNode(nodeText2);
                this.resetKeyChangedVariables(nodeText2);
                continue;
            }
            if (!nodeText2[3].equals(this.iv)) {
                this.addInstalledAvailableNodeToTree();
                this.resetInstalledOrAvailableNode(nodeText2);
                this.resetKeyChangedVariables(nodeText2);
                continue;
            }
            if (nodeText2[4].equals(this.version)) continue;
            this.addVersionNodeToTree();
            this.resetVersionNode(nodeText2);
            this.resetKeyChangedVariables(nodeText2);
        }
        this.addServiceNodeToTree(services);
    }

    private void resetKeyChangedVariables(String[] nodeText) {
        this.service = nodeText[0];
        this.form = nodeText[1];
        this.year = nodeText[2];
        this.iv = nodeText[3];
        this.version = nodeText[4];
    }

    private void resetServiceNode(String[] nodeText) {
        this.serviceNode = new DefaultMutableTreeNode(nodeText[0]);
        this.resetFormNode(nodeText);
    }

    private void resetFormNode(String[] nodeText) {
        this.formNode = new DefaultMutableTreeNode(nodeText[1]);
        this.resetYearNode(nodeText);
    }

    private void resetYearNode(String[] nodeText) {
        this.yearNode = new DefaultMutableTreeNode(nodeText[2]);
        this.resetInstalledOrAvailableNode(nodeText);
    }

    private void resetInstalledOrAvailableNode(String[] nodeText) {
        this.installedOrAvailableNode = new DefaultMutableTreeNode(nodeText[3]);
        this.resetVersionNode(nodeText);
    }

    private void resetVersionNode(String[] nodeText) {
        this.versionNode = new DefaultMutableTreeNode(nodeText[4]);
    }

    private void addServiceNodeToTree(DefaultMutableTreeNode services) {
        services.add(this.serviceNode);
        this.addFormNodeToTree();
    }

    private void addFormNodeToTree() {
        this.serviceNode.add(this.formNode);
        this.addYearNodeToTree();
    }

    private void addYearNodeToTree() {
        this.formNode.add(this.yearNode);
        this.addInstalledAvailableNodeToTree();
    }

    private void addInstalledAvailableNodeToTree() {
        this.yearNode.add(this.installedOrAvailableNode);
        this.addVersionNodeToTree();
    }

    private void addVersionNodeToTree() {
        this.installedOrAvailableNode.add(this.versionNode);
    }

    public RSSAccessor getRSSAccessor() {
        return feed;
    }
}

