/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.common.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class MarkableFileInputStream
extends InputStream {
    private long markPos = 0L;
    protected int markLimit = 0;
    private long totalBytes = 0L;
    private File file;
    private String filename;
    private FileDescriptor fileDescriptor;
    private FileInputStream fileIn;

    public MarkableFileInputStream(String name) throws FileNotFoundException {
        this.filename = name;
        this.fileIn = new FileInputStream(name);
    }

    public MarkableFileInputStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fileIn = new FileInputStream(file);
    }

    public MarkableFileInputStream(FileDescriptor fdObj) {
        this.fileDescriptor = fdObj;
        this.fileIn = new FileInputStream(fdObj);
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.fileIn.read();
        if (byteRead != -1) {
            ++this.totalBytes;
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.fileIn.read(b);
        if (bytesRead != -1) {
            this.totalBytes += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.fileIn.read(b, off, len);
        if (bytesRead != -1) {
            this.totalBytes += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = this.fileIn.skip(n);
        this.totalBytes += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        return this.fileIn.available();
    }

    @Override
    public void close() throws IOException {
        this.fileIn.close();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fileIn.getFD();
    }

    public FileChannel getChannel() {
        return this.fileIn.getChannel();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markLimit = readlimit;
        this.markPos = this.totalBytes;
    }

    @Override
    public synchronized void reset() throws IOException {
        FileChannel channel = this.getChannel();
        if (this.markPos > 0L && this.totalBytes - this.markPos <= (long)this.markLimit) {
            this.totalBytes = this.markPos;
        } else {
            this.markPos = 0L;
            this.markLimit = 0;
            this.totalBytes = 0L;
        }
        channel.position(this.markPos);
    }

    public static void main(String[] args) throws Exception {
        File testFile = new File("C:\\MarkableFileInputStream-Test.txt");
        testFile.deleteOnExit();
        if (!testFile.exists()) {
            testFile.createNewFile();
            FileWriter fileOut = new FileWriter(testFile);
            fileOut.write("1234567890abcdefghijklmnopqrstuvwxyz");
            fileOut.close();
        }
        try (MarkableFileInputStream mfis = new MarkableFileInputStream(testFile);){
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            mfis.mark(5);
            System.out.println("\tMARK. [Read limit = 5]");
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            mfis.reset();
            System.out.println("\tRESET");
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            mfis.reset();
            System.out.println("\tRESET");
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println("Read limit has just been exceeded (by 1)!");
            System.out.println("Reset() should now reset to very beginning of stream...");
            mfis.reset();
            System.out.println("\tRESET");
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
            System.out.println((char)mfis.read());
        }
    }
}

