/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.common.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import uk.gov.hmrc.aspire.esps.common.metadata.MetaDataException;

public class MetaDataParser {
    private final Map<String, String> valueElements = new HashMap<String, String>();
    private final Map<String, String> namespaceElements = new HashMap<String, String>();
    private final List<String> endMarkers = new ArrayList<String>();
    private List<String> missingRequiredFields;
    private int maxElementsToRead;
    private int tagsReadSoFar;
    private InputSource in;

    public MetaDataParser(InputStream in, int maxElementsToRead) {
        this.in = new InputSource(in);
        this.maxElementsToRead = maxElementsToRead;
    }

    public void addNamespaceElement(String elementName) {
        if (elementName != null) {
            this.namespaceElements.put(elementName, null);
        }
    }

    public void addEndMarkerElement(String elementName) {
        if (elementName != null) {
            this.endMarkers.add(elementName);
        }
    }

    public void addValueElement(String elementName) {
        if (elementName != null) {
            this.valueElements.put(elementName, null);
        }
    }

    public void parse() throws MetaDataException {
        this.parse(new MetaDataContentHandler());
    }

    public void parse(DefaultHandler contentHandler) throws MetaDataException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setContentHandler(contentHandler);
            this.missingRequiredFields = new ArrayList<String>(this.valueElements.keySet());
            this.missingRequiredFields.addAll(this.namespaceElements.keySet());
            xmlReader.parse(this.in);
        }
        catch (EndConditionMetException xmlReader) {
        }
        catch (SAXException saxe) {
            throw new MetaDataException(saxe);
        }
        catch (IOException ioe) {
            throw new MetaDataException(ioe);
        }
        catch (Exception e) {
            throw new MetaDataException(e);
        }
    }

    public String getValue(String tagName) {
        return this.valueElements.get(tagName);
    }

    public List<String> getMissingRequiredFields() {
        return this.missingRequiredFields;
    }

    public String getRequiredValue(String elementName) {
        String value = this.valueElements.get(elementName);
        if ((value == null || value.trim().equals("")) && ((value = this.namespaceElements.get(elementName)) == null || value.trim().equals(""))) {
            value = null;
        }
        return value;
    }

    private boolean isElementLimitReached(int elementCount) {
        if (this.maxElementsToRead > 0) {
            return this.tagsReadSoFar >= this.maxElementsToRead;
        }
        return false;
    }

    private boolean isEndMarker(String elementName) {
        return this.endMarkers.contains(elementName);
    }

    private class MetaDataContentHandler
    extends DefaultHandler {
        private String elementName = null;
        private StringBuffer chars;

        private MetaDataContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (MetaDataParser.this.valueElements.containsKey(this.elementName)) {
                this.chars.append(new String(ch, start, length).trim());
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws EndConditionMetException {
            ++MetaDataParser.this.tagsReadSoFar;
            this.chars = new StringBuffer();
            if (!MetaDataParser.this.valueElements.containsValue(null) && !MetaDataParser.this.namespaceElements.containsValue(null) || MetaDataParser.this.isEndMarker(localName) || MetaDataParser.this.isElementLimitReached(MetaDataParser.this.tagsReadSoFar)) {
                throw new EndConditionMetException("An end condition for the parsing process has been fulfilled");
            }
            this.elementName = !localName.equalsIgnoreCase("Key") ? localName : attributes.getValue("Type");
            if (MetaDataParser.this.namespaceElements.containsKey(this.elementName) && uri != null) {
                MetaDataParser.this.namespaceElements.put(this.elementName, uri);
            }
            MetaDataParser.this.missingRequiredFields.remove(this.elementName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws EndConditionMetException {
            if (MetaDataParser.this.valueElements.containsKey(this.elementName) && this.chars != null && !this.chars.toString().equals("")) {
                MetaDataParser.this.valueElements.put(this.elementName, this.chars.toString());
            }
            this.elementName = null;
            this.chars = null;
            if (!MetaDataParser.this.valueElements.containsValue(null) && !MetaDataParser.this.namespaceElements.containsValue(null) || MetaDataParser.this.isElementLimitReached(MetaDataParser.this.tagsReadSoFar)) {
                throw new EndConditionMetException("An end condition for the parsing process has been fulfilled");
            }
        }
    }

    private class EndConditionMetException
    extends SAXParseException {
        private static final long serialVersionUID = 1L;

        EndConditionMetException(String s) {
            super(s, (Locator)null);
        }
    }
}

