/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.lts.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.gov.hmrc.aspire.esps.lts.logger.Logger;
import uk.gov.hmrc.aspire.lts.LTSSystemException;

public class AuditLogger
implements Logger {
    private static File logFile;
    private static AuditLogger logger;
    private static final String WORKING_DIR;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final SimpleDateFormat dateTimeFormatter;

    private AuditLogger() {
    }

    public static AuditLogger create() {
        File logDir = new File(WORKING_DIR + "/logs");
        logFile = new File(String.valueOf(logDir.getAbsoluteFile()) + "/audit.log");
        if (!logDir.exists()) {
            logDir.mkdir();
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                throw new LTSSystemException(e);
            }
        }
        if (logger == null) {
            logger = new AuditLogger();
        }
        return logger;
    }

    public void audit(String field2) {
        this.writeLog(field2);
    }

    public void audit(String field2, String field3) {
        this.writeLog(field2 + "\t" + field3);
    }

    public void audit(String field2, String field3, String field4) {
        this.writeLog(field2 + "\t" + field3 + "\t" + field4);
    }

    public void audit(String field2, String field3, String field4, String field5) {
        this.writeLog(field2 + "\t" + field3 + "\t" + field4 + "\t" + field5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLog(String message) {
        StringBuffer entry = new StringBuffer();
        entry.append(dateTimeFormatter.format(new Date()));
        entry.append("\t");
        entry.append(message);
        entry.append("\n\r");
        OutputStream os = null;
        try {
            os = this.getLogStream();
            os.write(entry.toString().getBytes());
            os.flush();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public String getLogFilename() {
        return logFile.getAbsolutePath();
    }

    @Override
    public void setLogFile(File file) {
        logFile = file;
    }

    @Override
    public OutputStream getLogStream() throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(logFile, true);
        return fos;
    }

    static {
        WORKING_DIR = System.getProperty("user.dir");
        dateTimeFormatter = new SimpleDateFormat(DATE_TIME_FORMAT);
    }
}

