/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.composers;

import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.composers._IMessageComposer;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;

public class MessageComposer
implements _IMessageComposer {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    public OMElement composeMessage(LTSRequest request, LTSResponse response) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        Map<String, OMNode> errors = response.getErrors();
        if (errors != null && !errors.isEmpty()) {
            this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tComposing error response message.");
            OMNamespace errorRespNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");
            OMElement errorResponse = factory.createOMElement("ErrorResponse", errorRespNamespace);
            OMAttribute schemaVersion = factory.createOMAttribute("SchemaVersion", null, "2.0");
            errorResponse.addAttribute(schemaVersion);
            OMElement application = factory.createOMElement("Application", errorRespNamespace, (OMContainer)errorResponse);
            OMElement messageCount = factory.createOMElement("MessageCount", errorRespNamespace, (OMContainer)application);
            messageCount.addChild((OMNode)factory.createOMText("" + errors.size()));
            for (String node : errors.keySet()) {
                errorResponse.addChild(errors.get(node));
            }
            response.setErrorResponseMessage(errorResponse);
        } else if (response.getStaticResponseData() != null) {
            this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tComposing pre-configured response message.");
            response.setErrorResponseMessage(response.getStaticResponseData());
        } else {
            this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tComposing success response message.");
            OMNamespace successNamespace = factory.createOMNamespace("http://www.inlandrevenue.gov.uk/SuccessResponse", "");
            OMElement successResponse = factory.createOMElement("SuccessResponse", successNamespace);
            Map<String, OMNode> success = response.getSuccessResponses();
            for (String node : success.keySet()) {
                successResponse.addChild(success.get(node));
            }
            OMElement message = factory.createOMElement("Message", successNamespace, (OMContainer)successResponse);
            OMAttribute msgAttribute = factory.createOMAttribute("code", null, "077001");
            message.addAttribute(msgAttribute);
            message.addChild((OMNode)factory.createOMText("Thank you for your submission"));
            OMElement acceptedTime = factory.createOMElement("AcceptedTime", successNamespace, (OMContainer)successResponse);
            acceptedTime.addChild((OMNode)factory.createOMText(request.getMetaData().get("GatewayTimestamp")));
            response.setSuccessResponseMessage(successResponse);
        }
        return response.getEnvelopeWrapper().wrapEnvelope(request, response);
    }
}

