/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.composers;

import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.composers._IMessageComposer;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;

public class PAYEMessageComposer
implements _IMessageComposer {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    public OMElement composeMessage(LTSRequest request, LTSResponse response) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        Map<String, OMNode> errors = response.getErrors();
        if (errors != null && !errors.isEmpty()) {
            this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tComposing error response message.");
            OMNamespace errorRespNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");
            OMElement errorResponse = factory.createOMElement("ErrorResponse", errorRespNamespace);
            OMAttribute schemaVersion = factory.createOMAttribute("SchemaVersion", null, "2.0");
            errorResponse.addAttribute(schemaVersion);
            OMElement application = factory.createOMElement("Application", errorRespNamespace, (OMContainer)errorResponse);
            OMElement messageCount = factory.createOMElement("MessageCount", errorRespNamespace, (OMContainer)application);
            messageCount.addChild((OMNode)factory.createOMText("" + errors.size()));
            for (String node : errors.keySet()) {
                errorResponse.addChild(errors.get(node));
            }
            response.setErrorResponseMessage(errorResponse);
        } else {
            response.setSuccessResponseMessage(response.getSuccessResponseMessage());
        }
        return response.getEnvelopeWrapper().wrapEnvelope(request, response);
    }
}

