/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.composers.envelope;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.composers.envelope._IEnvelopeWrapper;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;

public class GovTalkEnvWrapper
implements _IEnvelopeWrapper {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    public OMElement wrapEnvelope(LTSRequest request, LTSResponse response) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement successResponseMsg = response.getSuccessResponseMessage();
        OMElement errorResponseMsg = response.getErrorResponseMessage();
        boolean successMessage = errorResponseMsg == null;
        OMNamespace govTalkNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/envelope", "");
        OMElement govTalkMessage = factory.createOMElement("GovTalkMessage", govTalkNamespace);
        OMElement envelopeVersion = factory.createOMElement("EnvelopeVersion", govTalkNamespace, (OMContainer)govTalkMessage);
        envelopeVersion.addChild((OMNode)factory.createOMText("2.0"));
        OMElement header = factory.createOMElement("Header", govTalkNamespace, (OMContainer)govTalkMessage);
        OMElement messageDetails = factory.createOMElement("MessageDetails", govTalkNamespace, (OMContainer)header);
        OMElement clazz = factory.createOMElement("Class", govTalkNamespace, (OMContainer)messageDetails);
        clazz.addChild((OMNode)factory.createOMText(request.getMessageType()));
        OMElement qualifier = factory.createOMElement("Qualifier", govTalkNamespace, (OMContainer)messageDetails);
        if (errorResponseMsg != null) {
            qualifier.addChild((OMNode)factory.createOMText("error"));
        } else {
            qualifier.addChild((OMNode)factory.createOMText("response"));
        }
        OMElement function = factory.createOMElement("Function", govTalkNamespace, (OMContainer)messageDetails);
        function.addChild((OMNode)factory.createOMText("submit"));
        OMElement correlationID = factory.createOMElement("CorrelationID", govTalkNamespace, (OMContainer)messageDetails);
        correlationID.addChild((OMNode)factory.createOMText(request.getMetaData().get("CorrelationID")));
        OMElement responseEndPoint = factory.createOMElement("ResponseEndPoint", govTalkNamespace, (OMContainer)messageDetails);
        OMElement Transformation = factory.createOMElement("Transformation", govTalkNamespace, (OMContainer)messageDetails);
        Transformation.addChild((OMNode)factory.createOMText("XML"));
        responseEndPoint.addChild((OMNode)factory.createOMText("http://localhost:5665/LTS/LTSServlet"));
        OMElement gatewayTimestamp = factory.createOMElement("GatewayTimestamp", govTalkNamespace, (OMContainer)messageDetails);
        gatewayTimestamp.addChild((OMNode)factory.createOMText(request.getMetaData().get("GatewayTimestamp")));
        OMElement senderDetails = factory.createOMElement("SenderDetails", govTalkNamespace, (OMContainer)header);
        OMElement govTalkDetails = factory.createOMElement("GovTalkDetails", govTalkNamespace, (OMContainer)govTalkMessage);
        OMElement keys = factory.createOMElement("Keys", govTalkNamespace, (OMContainer)govTalkDetails);
        keys.addChild((OMNode)factory.createOMText(""));
        if (!successMessage) {
            OMElement govTalkErrors = factory.createOMElement("GovTalkErrors", govTalkNamespace, (OMContainer)govTalkDetails);
            OMElement error = factory.createOMElement("Error", govTalkNamespace, (OMContainer)govTalkErrors);
            OMElement raisedBy = factory.createOMElement("RaisedBy", govTalkNamespace, (OMContainer)error);
            raisedBy.addChild((OMNode)factory.createOMText("ChRIS"));
            OMElement number = factory.createOMElement("Number", govTalkNamespace, (OMContainer)error);
            number.addChild((OMNode)factory.createOMText("3001"));
            OMElement type = factory.createOMElement("Type", govTalkNamespace, (OMContainer)error);
            type.addChild((OMNode)factory.createOMText("business"));
            OMElement text = factory.createOMElement("Text", govTalkNamespace, (OMContainer)error);
            text.addChild((OMNode)factory.createOMText("Your submission failed due to business validation errors. Please see below for details."));
        }
        OMElement body = factory.createOMElement("Body", govTalkNamespace, (OMContainer)govTalkMessage);
        if (successMessage) {
            body.addChild((OMNode)successResponseMsg);
        } else {
            body.addChild((OMNode)errorResponseMsg);
        }
        this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tResponse Message composed.");
        return govTalkMessage;
    }
}

