/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.composers.soap;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.composers.MessageComposer;
import uk.gov.hmrc.aspire.lts.composers.envelope.SoapWrapperUtility;
import uk.gov.hmrc.aspire.lts.composers.envelope._IEnvelopeWrapper;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;

public abstract class SoapMessageComposer
extends MessageComposer {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    public OMElement composeMessage(LTSRequest request, LTSResponse response) {
        boolean staticResponse = false;
        Map<String, OMNode> errors = response.getErrors();
        if (response.getStaticResponseData() == null || errors.size() > 0) {
            super.composeMessage(request, response);
        } else if (response.getStaticResponseData() != null) {
            StringBuilder msgBuff = new StringBuilder();
            msgBuff.append(request.getValidationNamespace()).append("\t");
            msgBuff.append(request.getMetaData().get("CorrelationID"));
            msgBuff.append("\tComposing pre-configured response message.");
            this.logger.audit(msgBuff.toString());
            staticResponse = true;
            response.setStaticResponseMessage(response.getStaticResponseData());
        }
        SoapWrapperUtility swu = new SoapWrapperUtility();
        OMElement wrappedResponse = null;
        _IEnvelopeWrapper envelopeWrapper = response.getEnvelopeWrapper();
        OMElement responseMsg = envelopeWrapper.wrapEnvelope(request, response);
        wrappedResponse = staticResponse ? swu.wrapSoapEnvelope(responseMsg) : swu.wrapSoapEnvelope(responseMsg, this.getResponseWrapperElement(), this.getResponseWrapperNamespace());
        return wrappedResponse;
    }

    public abstract String getResponseWrapperNamespace();

    public abstract String getResponseWrapperElement();
}

