/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.composers.soap.emcs;

import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.composers.envelope.SoapWrapperUtility;
import uk.gov.hmrc.aspire.lts.composers.envelope._IEnvelopeWrapper;
import uk.gov.hmrc.aspire.lts.composers.soap.SoapMessageComposer;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;

public class AcknowledgeMessagesReceiptMessageComposer
extends SoapMessageComposer {
    private AuditLogger logger = LoggerFactory.getAuditLogger();
    public static final String ACK_WRAPPER_ELEMENT = "AcknowledgeMessagesReceiptResponse";
    public static final String ACK_WRAPPER_NAMESPACE = "http://www.govtalk.gov.uk/taxation/EMCS/AcknowledgeMessagesReceiptResponse/1";

    @Override
    public String getResponseWrapperElement() {
        return ACK_WRAPPER_ELEMENT;
    }

    @Override
    public String getResponseWrapperNamespace() {
        return ACK_WRAPPER_NAMESPACE;
    }

    @Override
    public OMElement composeMessage(LTSRequest request, LTSResponse response) {
        boolean staticResponse = false;
        if (response.getStaticResponseData() == null) {
            super.composeMessage(request, response);
        } else if (response.getStaticResponseData() != null) {
            StringBuilder msgBuff = new StringBuilder();
            msgBuff.append(request.getValidationNamespace()).append("\t");
            msgBuff.append(request.getMetaData().get("CorrelationID"));
            msgBuff.append("\tComposing pre-configured response message.");
            this.logger.audit(msgBuff.toString());
            staticResponse = true;
            response.setStaticResponseMessage(response.getStaticResponseData());
        }
        SoapWrapperUtility swu = new SoapWrapperUtility();
        OMElement wrappedResponse = null;
        _IEnvelopeWrapper envelopeWrapper = response.getEnvelopeWrapper();
        OMElement responseMsg = envelopeWrapper.wrapEnvelope(request, response);
        Map<String, OMNode> errors = response.getErrors();
        if (errors.isEmpty() & !staticResponse) {
            responseMsg = this.setAckResponse(request, response);
        }
        wrappedResponse = staticResponse ? swu.wrapSoapEnvelope(responseMsg) : swu.wrapSoapEnvelope(responseMsg, this.getResponseWrapperElement(), this.getResponseWrapperNamespace());
        return wrappedResponse;
    }

    private OMElement setAckResponse(LTSRequest request, LTSResponse response) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace successNamespace = factory.createOMNamespace("http://www.inlandrevenue.gov.uk/SuccessResponse", "");
        OMElement successResponse = factory.createOMElement("SuccessResponse", successNamespace);
        OMElement message = factory.createOMElement("Message", successNamespace, (OMContainer)successResponse);
        OMAttribute msgAttribute = factory.createOMAttribute("code", null, "077001");
        message.addAttribute(msgAttribute);
        message.addChild((OMNode)factory.createOMText("Thank you for your acknowledgement."));
        OMElement acceptedTime = factory.createOMElement("AcceptedTime", successNamespace, (OMContainer)successResponse);
        acceptedTime.addChild((OMNode)factory.createOMText(request.getMetaData().get("GatewayTimestamp")));
        return successResponse;
    }
}

