/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.connectors.soap.http.util;

import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.InvalidContentTypeException;

public class SoapContentType {
    public static final String SOAP_CONTENT_TYPE_PRIMARY = "application";
    public static final String SOAP_CONTENT_TYPE_SUB = "soap+xml";
    public static final String SOAP_CONTENT_TYPE_APP_XML = "application/soap+xml";
    public static final String SOAP_CONTENT_TYPE_TEXT_XML = "text/xml";
    public static final String SOAP_CONTENT_TYPE_PARAM_CHARSET = "charset";
    public static final String SOAP_CONTENT_TYPE_PARAM_ACTION = "action";
    private ContentType contentType;

    public SoapContentType(String fullContentType) throws InvalidContentTypeException {
        try {
            this.contentType = new ContentType(fullContentType);
        }
        catch (ParseException pe) {
            String MSG_FMT = "Specified content type \"%s\" isn't a valid content type";
            String msg = String.format("Specified content type \"%s\" isn't a valid content type", fullContentType);
            throw new InvalidContentTypeException(msg, pe);
        }
    }

    public String getFullContentType() {
        String fullContentType = this.contentType.toString();
        return fullContentType;
    }

    public String toString() {
        return this.getFullContentType();
    }

    public boolean validSoapContentType() {
        return this.contentType.match(SOAP_CONTENT_TYPE_APP_XML) || this.contentType.match(SOAP_CONTENT_TYPE_TEXT_XML);
    }

    public void setCharset(String theCharset) {
        this.contentType.setParameter(SOAP_CONTENT_TYPE_PARAM_CHARSET, theCharset);
    }

    public String getCharset() {
        String charset = this.contentType.getParameter(SOAP_CONTENT_TYPE_PARAM_CHARSET);
        return charset;
    }

    public void setSoapAction(String theSoapAction) {
        this.contentType.setParameter(SOAP_CONTENT_TYPE_PARAM_ACTION, theSoapAction);
    }

    public String getSoapAction() {
        String action = this.contentType.getParameter(SOAP_CONTENT_TYPE_PARAM_ACTION);
        return action;
    }
}

